/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.recorder;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.recorder.LifetimeRecorderConfig;
import carpettisaddition.commands.lifetime.recorder.Record;
import carpettisaddition.commands.lifetime.recorder.RecordWriterThread;
import carpettisaddition.commands.lifetime.utils.AbstractReason;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.CommandUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LifetimeRecorder
extends TranslationContext {
    private static final LifetimeRecorder INSTANCE = new LifetimeRecorder();
    private LifetimeRecorderConfig config;
    private final Random random = new Random();
    private final Object lock = new Object();
    private RecordWriterThread recordWriterThread = null;
    private RecorderState recorderState = RecorderState.STOPPED;

    private LifetimeRecorder() {
        super(LifeTimeTracker.getInstance().getTranslator().getDerivedTranslator("recorder"));
        this.config = LifetimeRecorderConfig.load();
    }

    public static LifetimeRecorder getInstance() {
        return INSTANCE;
    }

    public boolean hasPermission(class_2168 source) {
        if (this.config.consoleOrSinglePlayerOwnerOnly && !CommandUtils.isConsoleCommandSource(source) && !CommandUtils.isSinglePlayerOwner(source)) {
            return false;
        }
        return CommandUtils.hasPermissionLevel(source, this.config.requiredPermissionLevel);
    }

    public void addRecord(class_1297 entity, AbstractReason reason) {
        RecordWriterThread rwt = this.recordWriterThread;
        if (rwt == null || !this.config.enabled) {
            return;
        }
        if (this.config.maxOutputRecordCount > 0L && rwt.getRecordWritten() >= this.config.maxOutputRecordCount) {
            return;
        }
        if (this.config.maxOutputFileBytes > 0L && rwt.getBytesWritten() >= this.config.maxOutputFileBytes) {
            return;
        }
        if (this.config.sampleRate < 1.0 && (double)this.random.nextFloat() < this.config.sampleRate) {
            return;
        }
        Record record = Record.create(entity, Record.EventType.fromReason(reason), reason.getRecordId(), (JsonElement)reason.getRecordData());
        rwt.write(record);
    }

    private class_2554 ctf(String key, long current, long limit, Function<Long, class_2554> fmt) {
        class_2554 text = this.tr(key, fmt.apply(current), limit > 0L ? this.tr("status.capped", fmt.apply(limit), String.format("%.1f%%", 100.0 * (double)current / (double)limit)) : this.tr("status.unlimited", new Object[0]));
        if (limit > 0L && current >= limit) {
            Messenger.formatting(text, class_124.field_1054);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showStatus(class_2168 source) {
        class_2554 st2;
        class_2554 st1;
        RecordWriterThread rwt;
        Object object = this.lock;
        synchronized (object) {
            rwt = this.recordWriterThread;
            st1 = this.config.enabled ? Messenger.formatting(this.tr("status.enabled", new Object[0]), class_124.field_1060) : Messenger.formatting(this.tr("status.disabled", new Object[0]), class_124.field_1061);
            st2 = (class_2554)class_156.method_656(() -> {
                switch (this.recorderState.ordinal()) {
                    case 1: {
                        return Messenger.formatting(this.tr("status.running", new Object[0]), class_124.field_1060);
                    }
                    case 2: {
                        return Messenger.formatting(this.tr("status.paused", new Object[0]), class_124.field_1065);
                    }
                    case 0: {
                        return Messenger.formatting(this.tr("status.stopped", new Object[0]), class_124.field_1061);
                    }
                }
                throw new AssertionError();
            });
        }
        Messenger.tell(source, Messenger.s(" "));
        Messenger.tell(source, Messenger.formatting(this.tr("status.title", new Object[0]), class_124.field_1067));
        Messenger.tell(source, this.tr("status.status", st1, st2));
        if (!this.hasPermission(source)) {
            return 0;
        }
        if (rwt != null) {
            Messenger.tell(source, this.tr("status.output_file", Messenger.hover(Messenger.s((Object)rwt.getOutputFile().getFileName(), class_124.field_1062), Messenger.s(rwt.getOutputFile().toString()))));
        }
        Messenger.tell(source, this.ctf("status.record_written", rwt != null ? rwt.getRecordWritten() : 0L, this.config.maxOutputRecordCount, n -> Messenger.s(n, class_124.field_1054)));
        Messenger.tell(source, this.ctf("status.bytes_written", rwt != null ? rwt.getBytesWritten() : 0L, this.config.maxOutputFileBytes, n -> Messenger.s((Object)TextUtils.byteSizeSi(n), class_124.field_1060)));
        Messenger.tell(source, this.tr("status.sample_rate", Messenger.s((Object)String.format("%.1f%%", this.config.sampleRate * 100.0), this.config.sampleRate < 1.0 ? class_124.field_1065 : class_124.field_1077)));
        return 0;
    }

    public int reloadConfig(class_2168 source) {
        LifetimeRecorderConfig newConfig;
        try {
            newConfig = LifetimeRecorderConfig.loadNoCheck();
        }
        catch (IOException e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to load lifetime recorder config file", (Throwable)e);
            Messenger.tell(source, Messenger.formatting(this.tr("reload_config_failed", e), class_124.field_1061));
            return 0;
        }
        this.config = newConfig;
        Messenger.tell(source, this.tr("reload_config_ok", new Object[0]));
        if (!this.config.enabled) {
            this.stop(source);
        }
        return 1;
    }

    public int enableRecording(class_2168 source) {
        if (this.config.enabled) {
            Messenger.tell(source, this.tr("already_enabled", new Object[0]));
            return 0;
        }
        this.config.enabled = true;
        this.config.save();
        Messenger.tell(source, this.tr("enabled", new Object[0]));
        if (LifeTimeTracker.isActivated()) {
            String cmd = String.format("/%s tracking restart", "lifetime");
            Messenger.tell(source, Messenger.fancy(this.tr("need_rerun_to_start", new Object[0]), Messenger.s(cmd), Messenger.ClickEvents.suggestCommand(cmd)));
        }
        return 1;
    }

    public int disableRecording(class_2168 source) {
        if (!this.config.enabled) {
            Messenger.tell(source, this.tr("already_disabled", new Object[0]));
            return 0;
        }
        this.config.enabled = false;
        this.config.save();
        Messenger.tell(source, this.tr("disabled", new Object[0]));
        this.stop(source);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@NotNull class_2168 source, int currentTrackId) {
        this.stop(source);
        if (!this.config.enabled) {
            return;
        }
        if (this.config.maxTotalOutputFileBytes > 0L) {
            Optional<Pair<Integer, Long>> st = this.getOutputFilesStats();
            CarpetTISAdditionMod.LOGGER.debug("output file size stats: {}", st);
            if (st.isPresent()) {
                int count = (Integer)st.get().getFirst();
                if ((long)count >= this.config.maxTotalOutputFileCount) {
                    Messenger.tell(source, Messenger.formatting(this.tr("total_output_count_too_many", count, this.config.maxTotalOutputFileCount), class_124.field_1061));
                    return;
                }
                long sizeTotal = (Long)st.get().getSecond();
                if (sizeTotal >= this.config.maxTotalOutputFileBytes) {
                    Messenger.tell(source, Messenger.formatting(this.tr("total_output_size_too_large", TextUtils.byteSizeSi(sizeTotal), TextUtils.byteSizeSi(this.config.maxTotalOutputFileBytes)), class_124.field_1061));
                    return;
                }
            } else {
                Messenger.tell(source, Messenger.formatting(this.tr("total_output_size_unknown", new Object[0]), class_124.field_1061));
                return;
            }
        }
        String fileName = String.format("rec_%s_%d.jsonl", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), currentTrackId);
        Path outputFile = Paths.get(this.config.outputDirectory, fileName);
        RecordWriterThread newRwt = new RecordWriterThread(outputFile, this.config.maxOutputRecordCount, this.config.maxOutputFileBytes, rwt -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.recordWriterThread == rwt) {
                    this.recorderState = RecorderState.PAUSED;
                }
            }
        });
        Object object = this.lock;
        synchronized (object) {
            this.recordWriterThread = newRwt;
            this.recorderState = RecorderState.RUNNING;
        }
        Messenger.tell(source, this.tr("started", Messenger.s((Object)fileName, class_124.field_1062)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(@Nullable class_2168 source) {
        RecordWriterThread rwt = this.recordWriterThread;
        Object object = this.lock;
        synchronized (object) {
            this.recordWriterThread = null;
            this.recorderState = RecorderState.STOPPED;
        }
        if (rwt == null) {
            return false;
        }
        rwt.close();
        if (source != null) {
            Messenger.tell(source, this.tr("stopped", Messenger.s((Object)rwt.getRecordWritten(), class_124.field_1054), Messenger.s((Object)TextUtils.byteSizeSi(rwt.getBytesWritten()), class_124.field_1060)));
        }
        return true;
    }

    private Optional<Pair<Integer, Long>> getOutputFilesStats() {
        Optional<Pair> optional;
        block9: {
            Path path = Paths.get(this.config.outputDirectory, new String[0]);
            Stream<Path> fileStream = Files.list(path);
            try {
                List files = fileStream.filter(f -> f.getFileName().toString().endsWith(".jsonl") && Files.isRegularFile(f, new LinkOption[0])).collect(Collectors.toList());
                long total = 0L;
                for (Path file : files) {
                    total += Files.size(file);
                }
                optional = Optional.of(Pair.of((Object)files.size(), (Object)total));
                if (fileStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CarpetTISAdditionMod.LOGGER.error("List lifetime recorder output files failed", (Throwable)e);
                    return Optional.empty();
                }
            }
            fileStream.close();
        }
        return optional;
    }

    private static enum RecorderState {
        STOPPED,
        RUNNING,
        PAUSED;

    }
}

