/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.raid;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.commands.raid.RaidWithIdAndWorld;
import carpettisaddition.mixins.command.raid.RaidAccessor;
import carpettisaddition.mixins.command.raid.RaidManagerAccessor;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.IdentifierUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_3765;

public class RaidCommand
extends AbstractCommand {
    private static final RaidCommand INSTANCE = new RaidCommand();

    public static RaidCommand getInstance() {
        return INSTANCE;
    }

    public RaidCommand() {
        super("raid");
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"raid").requires(player -> CarpetModUtil.canUseCommand(player, CarpetTISAdditionSettings.commandRaid))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(c -> this.listRaid((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"full").executes(c -> this.listRaid((class_2168)c.getSource(), true))))).then(RaidTracker.getInstance().getTrackingArgumentBuilder());
        context.dispatcher.register(builder);
    }

    public int listRaid(class_2168 source, boolean fullMode) {
        if (CarpetTISAdditionServer.minecraft_server == null) {
            return 0;
        }
        boolean hasRaid = false;
        for (class_3218 world : CarpetTISAdditionServer.minecraft_server.method_3738()) {
            Map<Integer, class_3765> raids = ((RaidManagerAccessor)world.method_19495()).getRaids();
            if (raids.isEmpty()) continue;
            ArrayList<class_2554> result = new ArrayList<class_2554>();
            result.add(Messenger.c(Messenger.dimension(DimensionWrapper.of((class_1937)world)), "w  ", this.tr("raid_count", raids.size())));
            hasRaid |= raids.size() > 0;
            for (Map.Entry<Integer, class_3765> entry : raids.entrySet()) {
                class_3765 raid = entry.getValue();
                int raidId = ((RaidWithIdAndWorld)raid).getRaidId$TISCM();
                RaidAccessor raidAccessor = (RaidAccessor)raid;
                int currentWave = raidAccessor.getWavesSpawned();
                String status = raidAccessor.getStatus().method_20026();
                result.add(Messenger.c("g - ", Messenger.tr("event.minecraft.raid", new Object[0]), String.format("w  #%d", raidId)));
                result.add(Messenger.c("g   ", this.tr("status", new Object[0]), "w : ", this.tr("status." + status, new Object[0])));
                result.add(Messenger.c("g   ", this.tr("center", new Object[0]), "w : ", Messenger.coord("w", (class_2382)raid.method_16495(), DimensionWrapper.of((class_1937)world))));
                result.add(Messenger.c("g   ", this.tr("bad_omen_level", new Object[0]), "w : ", Messenger.s(raid.method_16493())));
                result.add(Messenger.c("g   ", this.tr("waves", new Object[0]), "w : ", String.format("w %d/%d", raidAccessor.getWavesSpawned(), raidAccessor.getWaveCount())));
                Set<class_3763> raiders = raidAccessor.getWaveToRaiders().get(currentWave);
                boolean hasRaiders = raiders != null && !raiders.isEmpty();
                result.add(Messenger.c("g   ", this.tr("raiders", new Object[0]), "w : ", hasRaiders ? Messenger.s(String.format("x%d", raiders.size())) : this.tr("none", new Object[0])));
                if (!hasRaiders) continue;
                int counter = 0;
                ArrayList line = Lists.newArrayList();
                Iterator<class_3763> iter = raiders.iterator();
                while (iter.hasNext()) {
                    class_3763 raider = iter.next();
                    class_2554 raiderName = Messenger.entity(raider.equals((Object)raidAccessor.getWaveToCaptain().get(currentWave)) ? "r" : "w", (class_1297)raider);
                    class_2554 raiderMessage = Messenger.c(raiderName, "g  @ ", Messenger.coord("w", raider.method_19538(), DimensionWrapper.of((class_1297)raider)));
                    if (fullMode) {
                        result.add(Messenger.c("g   - ", raiderMessage));
                        continue;
                    }
                    class_2554 x = Messenger.s(String.format("[%s] ", IdentifierUtils.id(raider.method_5864()).method_12832().substring(0, 1).toUpperCase()));
                    x.method_10862(raiderName.method_10866().method_10960());
                    Messenger.hover(x, raiderMessage);
                    Messenger.click(x, Messenger.ClickEvents.suggestCommand(TextUtils.tp((class_1297)raider)));
                    line.add(x);
                    if (++counter != 10 && iter.hasNext()) continue;
                    line.add(0, "w     ");
                    result.add(Messenger.c(line.toArray(new Object[0])));
                    line.clear();
                    counter = 0;
                }
            }
            Messenger.tell(source, result);
        }
        if (!hasRaid) {
            Messenger.tell(source, this.tr("no_raid", new Object[0]));
        }
        return 1;
    }
}

