/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.EventSource;
import carpettisaddition.translations.TranslationContext;
import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2554;

public abstract class BaseEvent
extends TranslationContext {
    protected static final String COLOR_ACTION = "c";
    protected static final String COLOR_TARGET = "c";
    protected static final String COLOR_RESULT = "q";
    private final EventSource eventSource;
    private EventType eventType;

    protected BaseEvent(EventType eventType, String translateKey, EventSource eventSource) {
        super(MicroTimingLoggerManager.TRANSLATOR.getTranslationPath() + ".event." + translateKey);
        this.eventType = eventType;
        this.eventSource = eventSource;
    }

    protected BaseEvent(EventType eventType, String translateKey, class_2248 eventSourceBlock) {
        this(eventType, translateKey, new EventSource.BlockEventSource(eventSourceBlock));
    }

    public abstract class_2554 toText();

    public boolean isImportant() {
        return true;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        return Objects.equals(this.eventSource, baseEvent.eventSource) && this.eventType == baseEvent.eventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventSource, this.eventType});
    }

    public void mergeQuitEvent(BaseEvent quitEvent) {
        if (this.eventType == EventType.ACTION_START && quitEvent.eventType == EventType.ACTION_END) {
            this.eventType = EventType.ACTION;
        }
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }
}

