/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.tickwarp;

import carpettisaddition.commands.CommandExtender;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.logging.loggers.AbstractHUDLogger;
import carpettisaddition.logging.loggers.tickwarp.DefaultTickWarpInfo;
import carpettisaddition.logging.loggers.tickwarp.MemorizedTickWarpInfo;
import carpettisaddition.logging.loggers.tickwarp.TickWarpInfo;
import carpettisaddition.logging.loggers.tickwarp.TickWarpInfoReader;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2554;

public class TickWarpHUDLogger
extends AbstractHUDLogger
implements CommandExtender {
    public static final String NAME = "tickWarp";
    private static final TickWarpHUDLogger INSTANCE = new TickWarpHUDLogger();
    private final TickWarpInfo realtimeInfo = new DefaultTickWarpInfo();
    private final MemorizedTickWarpInfo historyInfo = new MemorizedTickWarpInfo(this.realtimeInfo);

    private TickWarpHUDLogger() {
        super(NAME, true);
    }

    public static TickWarpHUDLogger getInstance() {
        return INSTANCE;
    }

    private class_2554 getSourceName(TickWarpInfo info) {
        class_2168 advancer = info.getTimeAdvancer();
        return advancer != null ? (class_2554)advancer.method_9223() : this.tr("server", new Object[0]);
    }

    private class_2554 getProgressBar(TickWarpInfoReader info) {
        double progressRate = info.getProgressRate();
        ArrayList list = Lists.newArrayList();
        list.add("g [");
        for (int i = 1; i <= 10; ++i) {
            list.add(progressRate >= (double)i / 10.0 ? "g #" : "f -");
        }
        list.add("g ]");
        return Messenger.c(list.toArray(new Object[0]));
    }

    private class_2554 getDurationRatio(TickWarpInfoReader info) {
        return Messenger.c(String.format("g %d", info.getCompletedTicks()), "f /", String.format("g %d", info.getTotalTicks()));
    }

    private class_2554 getProgressPercentage(TickWarpInfoReader info) {
        return Messenger.c(String.format("g %.1f%%", info.getProgressRate() * 100.0));
    }

    @Override
    public String[] getSuggestedLoggingOption() {
        return new String[]{"bar", "value"};
    }

    @Override
    public class_2554[] onHudUpdate(String option, class_1657 playerEntity) {
        if (!this.realtimeInfo.isWarping()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        list.add("g Warp ");
        if (option.equals("bar")) {
            list.add(this.getProgressBar(this.realtimeInfo));
        } else if (option.equals("value")) {
            list.add(this.getDurationRatio(this.realtimeInfo));
        } else {
            list.add(this.getProgressBar(this.realtimeInfo));
        }
        list.add("w  ");
        list.add(this.getProgressPercentage(this.realtimeInfo));
        return new class_2554[]{Messenger.c(list.toArray(new Object[0]))};
    }

    @Override
    public void extendCommand(CommandTreeContext.Node context) {
        LiteralArgumentBuilder warpNode = class_2170.method_9247((String)"warp");
        warpNode.then(class_2170.method_9247((String)"status").executes(c -> this.showTickWarpInfo((class_2168)c.getSource())));
        context.node.then((ArgumentBuilder)warpNode);
    }

    private static void addLine(List<class_2554> list, class_2554 name, Object data) {
        list.add(Messenger.c(name, "g : ", data));
    }

    private class_2554 getTimeInfo(TickWarpInfoReader info, long ticks) {
        return this.tr("time_info", String.format("%.2f", (double)ticks / 20.0 / 60.0), String.format("%.2f", (double)ticks / info.getAverageTPS() / 60.0));
    }

    private void generateTickWarpInfo(TickWarpInfo info, List<class_2554> result) {
        result.add(Messenger.s(" "));
        TickWarpHUDLogger.addLine(result, this.tr("starter", new Object[0]), this.getSourceName(info));
        TickWarpHUDLogger.addLine(result, this.tr("average_tps", new Object[0]), String.format("w %.2f", info.getAverageTPS()));
        TickWarpHUDLogger.addLine(result, this.tr("average_mspt", new Object[0]), String.format("w %.2f", info.getAverageMSPT()));
        TickWarpHUDLogger.addLine(result, this.tr("elapsed_time", new Object[0]), this.getTimeInfo(info, info.getCompletedTicks()));
        TickWarpHUDLogger.addLine(result, this.tr("estimated_time", new Object[0]), this.getTimeInfo(info, info.getRemainingTicks()));
        result.add(Messenger.c(this.getProgressBar(info), "w  ", this.getProgressPercentage(info), "w  ", this.getDurationRatio(info)));
    }

    private int showTickWarpInfo(class_2168 source) {
        ArrayList result = Lists.newArrayList();
        if (this.realtimeInfo.isWarping()) {
            this.generateTickWarpInfo(this.realtimeInfo, result);
        } else if (this.historyInfo.hasData()) {
            result.add(this.tr("show_history_header", String.format("%.2f", (double)(System.nanoTime() - this.historyInfo.getLastRecordingTime()) / 1.0E9 / 60.0)));
            this.generateTickWarpInfo(this.historyInfo, result);
        } else {
            result.add(this.tr("not_started", new Object[0]));
        }
        Messenger.tell(source, (Iterable<class_2554>)result);
        return 1;
    }

    public void recordTickWarpAdvancer(class_2168 advancer) {
        this.realtimeInfo.setTimeAdvancer(advancer);
        this.historyInfo.setTimeAdvancer(advancer);
    }

    public void recordTickWarpResult() {
        this.historyInfo.recordResultIfsuitable();
    }
}

