/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.mixins.carpet.access.MessengerInvoker;
import carpettisaddition.mixins.utils.messenger.StyleAccessor;
import carpettisaddition.mixins.utils.messenger.TranslatableTextAccessor;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.IdentifierUtils;
import carpettisaddition.utils.TextUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messenger {
    private static final Translator translator = new Translator("util");
    private static final ImmutableMap<class_1767, Consumer<class_2554>> DYE_COLOR_APPLIER = (ImmutableMap)class_156.method_656(() -> {
        HashMap map = Maps.newHashMap();
        map.put(class_1767.field_7952, class_124.field_1068);
        map.put(class_1767.field_7967, class_124.field_1080);
        map.put(class_1767.field_7944, class_124.field_1063);
        map.put(class_1767.field_7963, class_124.field_1074);
        map.put(class_1767.field_7964, class_124.field_1061);
        map.put(class_1767.field_7947, class_124.field_1054);
        map.put(class_1767.field_7961, class_124.field_1060);
        map.put(class_1767.field_7942, class_124.field_1077);
        map.put(class_1767.field_7955, class_124.field_1062);
        map.put(class_1767.field_7951, class_124.field_1075);
        map.put(class_1767.field_7966, class_124.field_1058);
        map.put(class_1767.field_7945, class_124.field_1064);
        map.put(class_1767.field_7958, class_124.field_1076);
        map.put(class_1767.field_7957, class_124.field_1079);
        map.put(class_1767.field_7954, class_124.field_1061);
        map.put(class_1767.field_7946, class_124.field_1065);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        map.forEach((dyeColor, fmt) -> builder.put(dyeColor, text -> Messenger.formatting(text, fmt)));
        return builder.build();
    });
    private static final ImmutableMap<DimensionWrapper, class_2554> DIMENSION_NAME = ImmutableMap.of((Object)DimensionWrapper.OVERWORLD, (Object)Messenger.tr("createWorld.customize.preset.overworld", new Object[0]), (Object)DimensionWrapper.THE_NETHER, (Object)Messenger.tr("advancements.nether.root.title", new Object[0]), (Object)DimensionWrapper.THE_END, (Object)Messenger.tr("advancements.end.root.title", new Object[0]));

    public static class_2554 getTextContent(class_2554 text) {
        return text;
    }

    public static class_2554 c(Object ... fields) {
        return carpet.utils.Messenger.c((Object[])fields);
    }

    public static class_2554 s(Object text) {
        return new class_2585(text.toString());
    }

    public static class_2554 s(Object text, String carpetStyle) {
        return Messenger.formatting(Messenger.s(text), carpetStyle);
    }

    public static class_2554 s(Object text, class_124 ... textFormattings) {
        return Messenger.formatting(Messenger.s(text), textFormattings);
    }

    public static class_2554 newLine() {
        return Messenger.s("\n");
    }

    public static class_2554 colored(class_2554 text, class_1767 value) {
        Consumer consumer = (Consumer)DYE_COLOR_APPLIER.get((Object)value);
        if (consumer != null) {
            consumer.accept(text);
        }
        return text;
    }

    public static class_2554 colored(class_2554 text, Object value) {
        class_124 color = null;
        if (Boolean.TRUE.equals(value)) {
            color = class_124.field_1060;
        } else if (Boolean.FALSE.equals(value)) {
            color = class_124.field_1061;
        }
        if (value instanceof Number) {
            color = class_124.field_1065;
        }
        if (color != null) {
            Messenger.formatting(text, color);
        }
        return text;
    }

    public static class_2554 colored(Object value) {
        return Messenger.colored(Messenger.s(value), value);
    }

    public static class_2554 property(class_2769<?> property, Object value) {
        return Messenger.colored(Messenger.s(TextUtils.property(property, value)), value);
    }

    public static class_2554 tr(String key, Object ... args) {
        return new class_2588(key, args);
    }

    public static class_2554 fancy(@Nullable String carpetStyle, @NotNull class_2554 displayText, @Nullable class_2554 hoverText, @Nullable class_2558 clickEvent) {
        class_2554 text = Messenger.copy(displayText);
        if (carpetStyle != null) {
            text.method_10862(Messenger.parseCarpetStyle(carpetStyle));
        }
        if (hoverText != null) {
            Messenger.hover(text, hoverText);
        }
        if (clickEvent != null) {
            Messenger.click(text, clickEvent);
        }
        return text;
    }

    public static class_2554 fancy(class_2554 displayText, class_2554 hoverText, class_2558 clickEvent) {
        return Messenger.fancy(null, displayText, hoverText, clickEvent);
    }

    public static class_2554 join(class_2554 joiner, Iterable<class_2554> items) {
        class_2554 text = Messenger.s("");
        boolean first = true;
        for (class_2554 item : items) {
            if (!first) {
                text.method_10852((class_2561)joiner);
            }
            first = false;
            text.method_10852((class_2561)item);
        }
        return text;
    }

    public static class_2554 join(class_2554 joiner, class_2554 ... items) {
        return Messenger.join(joiner, Arrays.asList(items));
    }

    public static class_2554 joinLines(Iterable<class_2554> items) {
        return Messenger.join(Messenger.newLine(), items);
    }

    public static class_2554 joinLines(class_2554 ... items) {
        return Messenger.join(Messenger.newLine(), items);
    }

    public static class_2554 format(String formatter, Object ... args) {
        TranslatableTextAccessor dummy = (TranslatableTextAccessor)Messenger.tr(formatter, args);
        try {
            dummy.getTranslations().clear();
            dummy.invokeSetTranslation(formatter);
            return Messenger.c(dummy.getTranslations().toArray(new Object[0]));
        }
        catch (class_2590 e) {
            throw new IllegalArgumentException(formatter);
        }
    }

    public static class_2554 bool(boolean value) {
        return Messenger.s((Object)String.valueOf(value), value ? class_124.field_1060 : class_124.field_1061);
    }

    private static class_2554 getTeleportHint(class_2554 dest) {
        return translator.tr("teleport_hint", dest);
    }

    private static class_2554 __coord(String style, @Nullable DimensionWrapper dim, String posStr, String command) {
        class_2554 hoverText = Messenger.s("");
        hoverText.method_10852((class_2561)Messenger.getTeleportHint(Messenger.s(posStr)));
        if (dim != null) {
            hoverText.method_10864("\n");
            hoverText.method_10852((class_2561)translator.tr("teleport_hint.dimension", new Object[0]));
            hoverText.method_10864(": ");
            hoverText.method_10852((class_2561)Messenger.dimension(dim));
        }
        return Messenger.fancy(style, Messenger.s(posStr), hoverText, ClickEvents.suggestCommand(command));
    }

    public static class_2554 coord(String style, class_243 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtils.coord(pos), TextUtils.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_2382 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtils.coord(pos), TextUtils.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_1923 pos, DimensionWrapper dim) {
        return Messenger.__coord(style, dim, TextUtils.coord(pos), TextUtils.tp(pos, dim));
    }

    public static class_2554 coord(String style, class_243 pos) {
        return Messenger.__coord(style, null, TextUtils.coord(pos), TextUtils.tp(pos));
    }

    public static class_2554 coord(String style, class_2382 pos) {
        return Messenger.__coord(style, null, TextUtils.coord(pos), TextUtils.tp(pos));
    }

    public static class_2554 coord(String style, class_1923 pos) {
        return Messenger.__coord(style, null, TextUtils.coord(pos), TextUtils.tp(pos));
    }

    public static class_2554 coord(class_243 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_2382 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_1923 pos, DimensionWrapper dim) {
        return Messenger.coord(null, pos, dim);
    }

    public static class_2554 coord(class_243 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_2554 coord(class_2382 pos) {
        return Messenger.coord(null, pos);
    }

    public static class_2554 coord(class_1923 pos) {
        return Messenger.coord(null, pos);
    }

    private static class_2554 __vector(String style, String displayText, String detailedText) {
        return Messenger.fancy(style, Messenger.s(displayText), Messenger.s(detailedText), ClickEvents.suggestCommand(detailedText));
    }

    public static class_2554 vector(String style, class_243 vec) {
        return Messenger.__vector(style, TextUtils.vector(vec), TextUtils.vector(vec, 6));
    }

    public static class_2554 vector(class_243 vec) {
        return Messenger.vector(null, vec);
    }

    public static class_2554 entityType(class_1299<?> entityType) {
        return (class_2554)entityType.method_5897();
    }

    public static class_2554 entityType(class_1297 entity) {
        return Messenger.entityType(entity.method_5864());
    }

    public static class_2554 entity(String style, class_1297 entity) {
        class_2554 entityBaseName = Messenger.entityType(entity);
        class_2554 entityDisplayName = (class_2554)entity.method_5477();
        class_2554 hoverText = Messenger.c(translator.tr("entity_type", entityBaseName, Messenger.s(class_1299.method_5890((class_1299)entity.method_5864()).toString())), Messenger.newLine(), Messenger.getTeleportHint(entityDisplayName));
        return Messenger.fancy(style, entityDisplayName, hoverText, ClickEvents.suggestCommand(TextUtils.tp(entity)));
    }

    public static class_2554 entity(class_1297 entity) {
        return Messenger.entity(null, entity);
    }

    public static class_2554 attribute(class_1320 attribute) {
        return Messenger.tr("attribute.name." + attribute.method_6167(), new Object[0]);
    }

    public static class_2554 dimension(DimensionWrapper dim) {
        class_2554 dimText = (class_2554)DIMENSION_NAME.get((Object)dim);
        return dimText != null ? Messenger.copy(dimText) : Messenger.s(dim.getIdentifierString());
    }

    public static class_2554 dimensionColored(class_2554 text, DimensionWrapper dimensionType) {
        return Messenger.formatting(text, Messenger.getDimensionColor(dimensionType));
    }

    public static class_124 getDimensionColor(DimensionWrapper dimensionType) {
        if (dimensionType.equals(DimensionWrapper.OVERWORLD)) {
            return class_124.field_1077;
        }
        if (dimensionType.equals(DimensionWrapper.THE_NETHER)) {
            return class_124.field_1079;
        }
        if (dimensionType.equals(DimensionWrapper.THE_END)) {
            return class_124.field_1064;
        }
        return class_124.field_1068;
    }

    public static class_2554 getColoredDimensionSymbol(DimensionWrapper dimensionType) {
        String symbol = "?";
        if (dimensionType.equals(DimensionWrapper.OVERWORLD)) {
            symbol = "O";
        } else if (dimensionType.equals(DimensionWrapper.THE_NETHER)) {
            symbol = "N";
        } else if (dimensionType.equals(DimensionWrapper.THE_END)) {
            symbol = "E";
        } else {
            String id = dimensionType.getIdentifierString().toUpperCase();
            if (!id.isEmpty()) {
                symbol = id.substring(0, 1);
            }
        }
        return Messenger.s((Object)symbol, Messenger.getDimensionColor(dimensionType));
    }

    public static class_2554 block(class_2248 block) {
        return Messenger.hover(Messenger.tr(block.method_9539(), new Object[0]), Messenger.s(TextUtils.block(block)));
    }

    public static class_2554 block(class_2680 blockState) {
        ArrayList hovers = Lists.newArrayList();
        hovers.add(Messenger.s(TextUtils.block(blockState.method_11614())));
        for (class_2769 property : blockState.method_11569()) {
            hovers.add(Messenger.c(Messenger.s(property.method_11899()), "g : ", Messenger.property(property, blockState.method_11654(property))));
        }
        return Messenger.fancy(Messenger.block(blockState.method_11614()), Messenger.join(Messenger.s("\n"), hovers.toArray(new class_2554[0])), ClickEvents.suggestCommand(TextUtils.block(blockState)));
    }

    public static class_2554 fluid(class_3611 fluid) {
        return Messenger.hover(Messenger.block(fluid.method_15785().method_15759().method_11614()), Messenger.s(IdentifierUtils.id(fluid).toString()));
    }

    public static class_2554 fluid(class_3610 fluid) {
        return Messenger.fluid(fluid.method_15772());
    }

    public static class_2554 blockEntity(class_2586 blockEntity) {
        class_2960 id = IdentifierUtils.id(blockEntity.method_11017());
        return Messenger.s(id != null ? id.toString() : blockEntity.getClass().getSimpleName());
    }

    public static class_2554 item(class_1792 item) {
        return Messenger.tr(item.method_7876(), new Object[0]);
    }

    public static class_2554 color(class_1767 color) {
        return translator.tr("color." + color.method_7792().toLowerCase(), new Object[0]);
    }

    public static class_2554 hover(class_2554 text, class_2568 hoverEvent) {
        text.method_10866().method_10949(hoverEvent);
        return text;
    }

    public static class_2554 hover(class_2554 text, class_2554 hoverText) {
        return Messenger.hover(text, HoverEvents.showText((class_2561)hoverText));
    }

    public static class_2554 click(class_2554 text, class_2558 clickEvent) {
        text.method_10866().method_10958(clickEvent);
        return text;
    }

    public static class_2554 formatting(class_2554 text, class_124 ... formattings) {
        text.method_10856(formattings);
        return text;
    }

    public static class_2554 formatting(class_2554 text, String carpetStyle) {
        class_2583 textStyle = text.method_10866();
        StyleAccessor parsedStyle = (StyleAccessor)Messenger.parseCarpetStyle(carpetStyle);
        textStyle.method_10977(parsedStyle.getColor$TISCM());
        textStyle.method_10982(parsedStyle.getBold$TISCM());
        textStyle.method_10978(parsedStyle.getItalic$TISCM());
        textStyle.method_10968(parsedStyle.getUnderline$TISCM());
        textStyle.method_10959(parsedStyle.getStrikethrough$TISCM());
        textStyle.method_10948(parsedStyle.getObfuscated$TISCM());
        return Messenger.style(text, textStyle);
    }

    public static class_2554 style(class_2554 text, class_2583 style) {
        text.method_10862(style);
        return text;
    }

    public static class_2554 copy(class_2554 text) {
        class_2554 copied = (class_2554)text.method_10853();
        return copied;
    }

    private static void __tell(class_2168 source, class_2554 text, boolean broadcastToOps) {
        if (GameUtils.getOverworld(source.method_9211()) == null) {
            broadcastToOps = false;
        }
        source.method_9226((class_2561)text, broadcastToOps);
    }

    public static void tell(class_2168 source, class_2554 text, boolean broadcastToOps) {
        Messenger.__tell(source, text, broadcastToOps);
    }

    public static void tell(class_1657 player, class_2554 text, boolean broadcastToOps) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Messenger.tell(serverPlayer.method_5671(), text, broadcastToOps);
        }
    }

    public static void tell(class_2168 source, class_2554 text) {
        Messenger.tell(source, text, false);
    }

    public static void tell(class_1657 player, class_2554 text) {
        Messenger.tell(player, text, false);
    }

    public static void tell(class_2168 source, Iterable<class_2554> texts, boolean broadcastToOps) {
        texts.forEach(text -> Messenger.tell(source, text, broadcastToOps));
    }

    public static void tell(class_1657 player, Iterable<class_2554> texts, boolean broadcastToOps) {
        texts.forEach(text -> Messenger.tell(player, text, broadcastToOps));
    }

    public static void tell(class_2168 source, Iterable<class_2554> texts) {
        Messenger.tell(source, texts, false);
    }

    public static void tell(class_1657 player, Iterable<class_2554> texts) {
        Messenger.tell(player, texts, false);
    }

    public static void reminder(class_1657 player, class_2554 text) {
        player.method_7353((class_2561)text, true);
    }

    public static void sendToConsole(class_2554 text) {
        if (CarpetTISAdditionServer.minecraft_server != null) {
            CarpetTISAdditionServer.minecraft_server.method_9203((class_2561)text);
        }
    }

    public static void broadcast(class_2554 text) {
        Messenger.sendToConsole(text);
        if (CarpetTISAdditionServer.minecraft_server != null) {
            CarpetTISAdditionServer.minecraft_server.method_3760().method_14571().forEach(player -> Messenger.tell((class_1657)player, text));
        }
    }

    public static class_2583 parseCarpetStyle(String style) {
        return MessengerInvoker.call_applyStyleToTextComponent(Messenger.s(""), style).method_10866();
    }

    public static class_2554 getSpaceText() {
        return translator.tr("language.space", new Object[0]);
    }

    public static class ClickEvents {
        public static class_2558 runCommand(String command) {
            return new class_2558(class_2558.class_2559.field_11750, command);
        }

        public static class_2558 suggestCommand(String command) {
            return new class_2558(class_2558.class_2559.field_11745, command);
        }

        public static class_2558 openUrl(String url) {
            return new class_2558(class_2558.class_2559.field_11749, url);
        }
    }

    public static class HoverEvents {
        public static class_2568 showText(class_2561 text) {
            return new class_2568(class_2568.class_2569.field_11762, text);
        }
    }
}

