/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.skipcompression;

import carpettisaddition.commands.speedtest.skipcompression.PacketDeflaterWithNetworkSide;
import carpettisaddition.mixins.command.speedtest.PacketCodecDispatcherAccessor;
import carpettisaddition.network.TISCMProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2817;
import net.minecraft.class_9095;
import net.minecraft.class_9127;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9145;
import net.minecraft.class_9152;

public class SpeedTestCompressionSkipper {
    private static final byte[] DOWNLOAD_PACKET_BYTES_PREFIX = (byte[])class_156.method_656(() -> {
        TISCMProtocol.S2C packetId = TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD;
        return SpeedTestCompressionSkipper.makeBytes(SpeedTestCompressionSkipper.getMinecraftPacketId(class_2598.field_11942, packetId.packet(nbt -> {})), packetId.getId());
    });
    private static final byte[] UPLOAD_PACKET_BYTES_PREFIX = (byte[])class_156.method_656(() -> {
        TISCMProtocol.C2S packetId = TISCMProtocol.C2S.SPEED_TEST_UPLOAD_PAYLOAD;
        class_2817 examplePacket = packetId.packet(nbt -> {});
        return SpeedTestCompressionSkipper.makeBytes(SpeedTestCompressionSkipper.getMinecraftPacketId(class_2598.field_11941, examplePacket), packetId.getId());
    });

    private static byte[] makeBytes(int mcPacketId, String tiscmPacketId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(mcPacketId);
        buf.method_10812(TISCMProtocol.CHANNEL);
        buf.method_10814(tiscmPacketId);
        byte[] result = new byte[buf.readableBytes()];
        buf.method_52979(result);
        buf.release();
        return result;
    }

    private static int getMinecraftPacketId(class_2598 side, class_2596<?> packet) {
        try {
            class_9145 type;
            class_9127.class_9128 factory = side == class_2598.field_11941 ? class_9095.field_48172 : class_9095.field_48173;
            class_9139 codec = factory.method_61107(buf -> new class_9129(buf, null)).comp_2236();
            class_9145 class_91452 = type = side == class_2598.field_11941 ? class_9152.field_48641 : class_9152.field_48631;
            if (codec instanceof PacketCodecDispatcherAccessor) {
                PacketCodecDispatcherAccessor packetCodecDispatcher = (PacketCodecDispatcherAccessor)codec;
                int packetId = packetCodecDispatcher.getTypeToIndex().getOrDefault((Object)type, -1);
                if (packetId == -1) {
                    throw new IndexOutOfBoundsException("Failed to get packet id for %s from %s".formatted(type, packetCodecDispatcher));
                }
                return packetId;
            }
            throw new RuntimeException("codec is not a PacketCodecDispatcherAccessor");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get " + String.valueOf(side) + " packet id of " + String.valueOf(packet));
        }
    }

    public static boolean isSpeedTestPayloadPacket(PacketDeflaterWithNetworkSide deflater, ByteBuf byteBuf) {
        byte[] prefix;
        class_2598 side = deflater.getNetworkSide$TISCM();
        if (side == null) {
            return false;
        }
        switch (side) {
            case field_11941: {
                prefix = DOWNLOAD_PACKET_BYTES_PREFIX;
                break;
            }
            case field_11942: {
                prefix = UPLOAD_PACKET_BYTES_PREFIX;
                break;
            }
            default: {
                return false;
            }
        }
        byteBuf = byteBuf.slice();
        int n = byteBuf.readableBytes();
        if (n >= prefix.length && n >= 16184) {
            byte[] sample = new byte[prefix.length];
            byteBuf.readBytes(sample);
            return Arrays.equals(sample, prefix);
        }
        return false;
    }
}

