/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.movement;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingAccess;
import carpettisaddition.logging.loggers.movement.MovementLoggerTarget;
import carpettisaddition.logging.loggers.movement.MovementModification;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.WorldUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.entityfilter.EntityFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class MovementLogger
extends AbstractLogger {
    public static final String NAME = "movement";
    private static final String NON_ZERO_HEADER = "non_zero:";
    private static final MovementLogger INSTANCE = new MovementLogger();

    private MovementLogger() {
        super(NAME, false);
    }

    public static MovementLogger getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String[] getSuggestedLoggingOption() {
        return new String[]{"non_zero:@a[distance=..10]", "@s", "non_zero:@e[type=creeper,distance=..5]", "Steve"};
    }

    public static boolean isLoggerActivated() {
        return TISAdditionLoggerRegistry.__movement;
    }

    public void create(class_1297 entity, class_1313 movementType, class_243 originalMovement) {
        MovementLoggerTarget target;
        if (MovementLogger.isLoggerActivated() && EntityUtils.getEntityWorld(entity) instanceof class_3218 && !(target = (MovementLoggerTarget)entity).getMovementTracker().isPresent()) {
            target.setMovementTracker(new Tracker(entity, movementType, originalMovement));
        }
    }

    public void finalize(class_1297 entity) {
        if (MovementLogger.isLoggerActivated()) {
            MovementLoggerTarget target = (MovementLoggerTarget)entity;
            target.getMovementTracker().ifPresent(Tracker::report);
            target.setMovementTracker(null);
        }
    }

    public class Tracker {
        private static final double MIN_DIFFERENCE = 1.0E-12;
        private final class_1297 entity;
        private final class_243 originalPos;
        private final class_3218 world;
        private final class_1313 movementType;
        private final class_243 originalMovement;
        private class_243 currentMovement;
        private final List<ModificationRecord> modifications = Lists.newArrayList();

        public Tracker(class_1297 entity, class_1313 movementType, class_243 originalMovement) {
            this.entity = entity;
            this.originalPos = entity.method_19538();
            this.world = (class_3218)EntityUtils.getEntityWorld(entity);
            this.movementType = movementType;
            this.originalMovement = originalMovement;
            this.currentMovement = originalMovement;
        }

        public void recordModification(MovementModification modification, class_243 newMovement) {
            if (this.currentMovement.method_1020(newMovement).method_1033() >= 1.0E-12) {
                this.modifications.add(new ModificationRecord(this.currentMovement, newMovement, modification));
                this.currentMovement = newMovement;
            }
        }

        public boolean shouldReportFor(class_1657 player, String option) {
            if (option.isEmpty()) {
                option = player.method_7334().getName();
            }
            boolean ok = true;
            if (option.startsWith(MovementLogger.NON_ZERO_HEADER)) {
                ok &= this.currentMovement.method_1027() > 0.0;
                option = option.substring(MovementLogger.NON_ZERO_HEADER.length());
            }
            return ok &= EntityFilter.createOptional(player, option).map(filter -> filter.test(this.entity)).orElse(false).booleanValue();
        }

        public void report() {
            MovementLogger.this.log((option, player) -> {
                if (!this.shouldReportFor(player, option)) {
                    return null;
                }
                class_5250 entityName = Messenger.entity("b", this.entity);
                ArrayList lines = Lists.newArrayList();
                lines.add(Messenger.s(""));
                lines.add(Messenger.c(MovementLogger.this.tr("header", new Object[]{entityName, Messenger.vector("y", this.originalMovement)}), "g  @ ", Messenger.coord("g", this.originalPos, DimensionWrapper.of((class_1937)this.world))));
                lines.add(MovementLogger.this.tr("header_details", new Object[]{Messenger.formatting(MovementLogger.this.tr("movement_type." + this.movementType.name().toLowerCase(), new Object[]{""}), "c"), Messenger.c(Messenger.s((Object)WorldUtils.getWorldTime((class_1937)this.world), "q"), "w  ", MicroTimingAccess.getTickPhase(this.world).toText("q"))}));
                for (ModificationRecord record : this.modifications) {
                    class_5250 delta = Messenger.vector(record.newMovement.method_1020(record.oldMovement));
                    lines.add(Messenger.c("g  - ", Messenger.vector("y", record.oldMovement), Messenger.fancy("g", Messenger.s(" -> "), Messenger.c(MovementLogger.this.tr("delta", new Object[0]), "w : ", delta), delta.method_10866().method_10970()), Messenger.vector("d", record.newMovement), MovementLogger.this.tr("due_to", new Object[]{record.reason.toText()})));
                }
                lines.add(Messenger.c(MovementLogger.this.tr("footer", new Object[]{entityName, Messenger.vector("d", this.currentMovement)}), "g  @ ", Messenger.coord("g", this.entity.method_19538(), DimensionWrapper.of((class_1937)this.world))));
                return (class_2561[])lines.toArray(new class_5250[0]);
            });
        }
    }

    private static class ModificationRecord {
        public final MovementModification reason;
        public final class_243 oldMovement;
        public final class_243 newMovement;

        public ModificationRecord(class_243 oldMovement, class_243 newMovement, MovementModification reason) {
            this.reason = reason;
            this.oldMovement = oldMovement;
            this.newMovement = newMovement;
        }
    }
}

