/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.damage;

import carpettisaddition.logging.loggers.damage.DamageLogger;
import carpettisaddition.logging.loggers.damage.interfaces.DamageLoggerTarget;
import carpettisaddition.logging.loggers.damage.modifyreasons.ArmorModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.EnchantmentModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.ModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.StatusEffectModifyReason;
import carpettisaddition.utils.EntityUtils;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements DamageLoggerTarget {
    @Shadow
    protected float field_6253;
    @Nullable
    private DamageLogger.Tracker damageTracker$TISCM = null;

    @Shadow
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Override
    public Optional<DamageLogger.Tracker> getDamageTracker() {
        return Optional.ofNullable(this.damageTracker$TISCM);
    }

    @Override
    public void setDamageTracker(@Nullable DamageLogger.Tracker tracker) {
        this.damageTracker$TISCM = tracker;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isSleeping()Z")})
    private void onDamageStarted(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) class_1282 source, @Local(argsOnly=true) float amount) {
        DamageLogger.create((class_1309)this, source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="CONSTANT", args={"floatValue=0.75F"})})
    private void onHelmetReducedAnvilDamage(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) float amount) {
        this.getDamageTracker().ifPresent(tracker -> tracker.modifyDamage(amount * 0.75f, ModifyReason.HELMET));
    }

    @Inject(method={"damage"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V"))}, at={@At(value="FIELD", target="Lnet/minecraft/registry/tag/DamageTypeTags;IS_PROJECTILE:Lnet/minecraft/registry/tag/TagKey;", ordinal=0)})
    private void onShieldReducedDamage(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) float amount) {
        this.getDamageTracker().ifPresent(tracker -> tracker.modifyDamage(amount, ModifyReason.SHIELD));
    }

    @Inject(method={"damage"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;lastDamageTaken:F", ordinal=0)})
    private void onRecentHintReducedDamage(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) float amount) {
        float last = this.field_6253;
        this.getDamageTracker().ifPresent(tracker -> tracker.modifyDamage(Math.max(amount - last, 0.0f), ModifyReason.RECENTLY_HIT));
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="RETURN")})
    private void onArmorReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageTracker().ifPresent(tracker -> tracker.modifyDamage(amount, new ArmorModifyReason((class_1309)this)));
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/lang/Math;max(FF)F")})
    private void onResistanceReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageTracker().ifPresent(tracker -> tracker.modifyDamage(amount, new StatusEffectModifyReason((class_6880<class_1291>)class_1294.field_5907, (Integer)this.method_6112((class_6880<class_1291>)class_1294.field_5907).method_5578())));
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F")})
    private void onEnchantmentReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageTracker().ifPresent(tracker -> {
            class_1309 self = (class_1309)this;
            class_1937 world = EntityUtils.getEntityWorld((class_1297)self);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                double epf = class_1890.method_8219((class_3218)serverWorld, (class_1309)self, (class_1282)source);
                tracker.modifyDamage(amount, new EnchantmentModifyReason(epf));
            }
        });
    }
}

