/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.entity;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.manipulate.AbstractManipulator;
import carpettisaddition.mixins.command.manipulate.entity.MobEntityAccessor;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2561;

public class EntityManipulator
extends AbstractManipulator {
    public EntityManipulator() {
        super("entity");
    }

    @Override
    public void buildSubCommand(CommandTreeContext.Node context) {
        context.node.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rename").then(class_2170.method_9247((String)"clear").executes(c -> this.clearRename((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"))))).then(class_2170.method_9244((String)"name", (ArgumentType)class_2178.method_9281()).executes(c -> this.rename((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"), class_2178.method_9280((CommandContext)c, (String)"name")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"persistent").executes(c -> this.queryPersistentState((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target")))).then(class_2170.method_9244((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(c -> this.setPersistent((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"), BoolArgumentType.getBool((CommandContext)c, (String)"state")))))).then(class_2170.method_9247((String)"mount").then(class_2170.method_9244((String)"vehicle", (ArgumentType)class_2186.method_9309()).executes(c -> this.mount((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"), class_2186.method_9313((CommandContext)c, (String)"vehicle")))))).then(class_2170.method_9247((String)"dismount").executes(c -> this.dismount((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"velocity").executes(c -> this.queryVelocity((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target")))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(c -> this.addVelocity((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"), new class_243(DoubleArgumentType.getDouble((CommandContext)c, (String)"x"), DoubleArgumentType.getDouble((CommandContext)c, (String)"y"), DoubleArgumentType.getDouble((CommandContext)c, (String)"z"))))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"x", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"y", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"z", (ArgumentType)StringArgumentType.word()).executes(c -> this.setVelocity((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"target"), new class_243(EntityManipulator.s2d(StringArgumentType.getString((CommandContext)c, (String)"x")), EntityManipulator.s2d(StringArgumentType.getString((CommandContext)c, (String)"y")), EntityManipulator.s2d(StringArgumentType.getString((CommandContext)c, (String)"z")))))))))));
    }

    private static double s2d(String s) throws CommandSyntaxException {
        switch (s.toLowerCase()) {
            case "nan": {
                s = "NaN";
                break;
            }
            case "inf": 
            case "infinity": {
                s = "Infinity";
                break;
            }
            case "-inf": 
            case "-infinity": {
                s = "-Infinity";
            }
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().create((Object)s);
        }
    }

    private static <T> List<T> get(Collection<? extends class_1297> entities, Class<T> clazz) {
        return entities.stream().map(e -> clazz.isAssignableFrom(e.getClass()) ? e : null).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T extends class_1297> class_2554 entitiesText(Collection<T> entities) {
        int LIMIT = 15;
        class_2554 hover = Messenger.join(Messenger.s("\n"), (class_2554[])entities.stream().limit(15L).map(e -> Messenger.format("%1$s (%2$s)", Messenger.entityType(e), e.method_5845())).toArray(class_2554[]::new));
        if (entities.size() > 15) {
            hover.method_27693("\n...");
        }
        return Messenger.fancy(this.tr("entity_message", entities.size()), hover, null);
    }

    private int rename(class_2168 source, Collection<? extends class_1297> target, class_2561 name) {
        target.forEach(e -> e.method_5665(name));
        Messenger.tell(source, this.tr("rename.renamed", this.entitiesText(target), name));
        return target.size();
    }

    private int clearRename(class_2168 source, Collection<? extends class_1297> target) {
        target.forEach(e -> e.method_5665(null));
        Messenger.tell(source, this.tr("rename.cleared", this.entitiesText(target)));
        return target.size();
    }

    private int queryPersistentState(class_2168 source, Collection<? extends class_1297> entities) {
        List<class_1308> mobs = EntityManipulator.get(entities, class_1308.class);
        if (mobs.isEmpty()) {
            Messenger.tell(source, this.tr("persistent.not_found", new Object[0]));
        } else {
            Messenger.tell(source, this.tr("persistent.title", new Object[0]));
            mobs.forEach(e -> Messenger.tell(source, Messenger.format("  %1$s: %2$s", Messenger.entity((class_1297)e), Messenger.bool(e.method_5947()))));
        }
        return mobs.size();
    }

    private int setPersistent(class_2168 source, Collection<? extends class_1297> entities, boolean state) {
        List<class_1308> mobs = EntityManipulator.get(entities, class_1308.class);
        mobs.forEach(e -> ((MobEntityAccessor)e).setPersistent$TISCM(state));
        Messenger.tell(source, this.tr("persistent.set", this.entitiesText(mobs), Messenger.bool(state)));
        return mobs.size();
    }

    private int mount(class_2168 source, Collection<? extends class_1297> target, class_1297 vehicle) {
        List passengers = target.stream().filter(e -> !e.equals((Object)vehicle) && e.method_5873(vehicle, true)).collect(Collectors.toList());
        Messenger.tell(source, this.tr("mounted", this.entitiesText(passengers), Messenger.entity(vehicle)));
        return passengers.size();
    }

    private int dismount(class_2168 source, Collection<? extends class_1297> passengers) {
        List<class_1297> filtered = passengers.stream().filter(class_1297::method_5765).collect(Collectors.toList());
        filtered.forEach(class_1297::method_5848);
        Messenger.tell(source, this.tr("dismounted", this.entitiesText(filtered)));
        return filtered.size();
    }

    private int queryVelocity(class_2168 source, Collection<? extends class_1297> target) {
        Messenger.tell(source, this.tr("velocity.title", new Object[0]));
        target.forEach(e -> Messenger.tell(source, Messenger.format("  %1$s: %2$s", Messenger.entity(e), Messenger.vector(e.method_18798()))));
        return target.size();
    }

    private int addVelocity(class_2168 source, Collection<? extends class_1297> target, class_243 delta) {
        target.forEach(e -> e.method_5762(delta.field_1352, delta.field_1351, delta.field_1350));
        Messenger.tell(source, this.tr("velocity.added", this.entitiesText(target), Messenger.vector(delta)));
        return target.size();
    }

    private int setVelocity(class_2168 source, Collection<? extends class_1297> target, class_243 velocity) {
        target.forEach(e -> e.method_18799(velocity));
        Messenger.tell(source, this.tr("velocity.set", this.entitiesText(target), Messenger.vector(velocity)));
        return target.size();
    }
}

