/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.carpet.playerActionEnhanced.randomly;

import carpet.helpers.EntityPlayerActionPack;
import carpettisaddition.helpers.carpet.playerActionEnhanced.IEntityPlayerActionPackAction;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.CommandActionMaker;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.GaussianGen;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.PoissonGen;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.RandomGen;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.RangeLimitedGen;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.TriangularGen;
import carpettisaddition.helpers.carpet.playerActionEnhanced.randomly.gen.UniformGen;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import com.google.common.base.Strings;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class RandomizedActionIntervalCommand
extends TranslationContext {
    private static final RandomizedActionIntervalCommand INSTANCE = new RandomizedActionIntervalCommand();

    private RandomizedActionIntervalCommand() {
        super("command.player.action.randomly");
    }

    public static RandomizedActionIntervalCommand getInstance() {
        return INSTANCE;
    }

    public void extendCommand(ArgumentBuilder<class_2168, ?> node, EntityPlayerActionPack.ActionType type, CommandActionMaker actionMaker) {
        Function<Boolean, Command> uniformCmd = bool -> c -> actionMaker.action((CommandContext<class_2168>)c, type, this.uniformImpl((CommandContext<class_2168>)c, (boolean)bool));
        Command poissonCmd = c -> actionMaker.action((CommandContext<class_2168>)c, type, this.poissonImpl((CommandContext<class_2168>)c));
        Command gaussianCmd = c -> actionMaker.action((CommandContext<class_2168>)c, type, this.gaussianImpl((CommandContext<class_2168>)c));
        Command triangularCmd = c -> actionMaker.action((CommandContext<class_2168>)c, type, this.triangularImpl((CommandContext<class_2168>)c));
        EndpointCmdMaker endpoint = (n, cmd, g) -> n.executes(cmd).then(class_2170.method_9247((String)"--simulate").executes(c -> this.simulateRun((CommandContext<class_2168>)c, g.get((CommandContext<class_2168>)c))));
        node.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"randomly").executes(c -> this.randomlyHelp((class_2168)c.getSource()))).then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(uniformCmd.apply(true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"uniform").executes(c -> this.uniformHelp((class_2168)c.getSource()))).then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer((int)1)).then(endpoint.make((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1)), (Command<class_2168>)uniformCmd.apply(false), this::uniformGen))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"poisson").executes(c -> this.poissonHelp((class_2168)c.getSource()))).then(class_2170.method_9244((String)"origin", (ArgumentType)DoubleArgumentType.doubleArg()).then(endpoint.make(class_2170.method_9244((String)"maxima", (ArgumentType)DoubleArgumentType.doubleArg()).then(endpoint.make((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"upper_bound", (ArgumentType)IntegerArgumentType.integer((int)1)), (Command<class_2168>)poissonCmd, this::poissonGen)), (Command<class_2168>)poissonCmd, this::poissonGen))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gaussian").executes(c -> this.gaussianHelp((class_2168)c.getSource()))).then(class_2170.method_9244((String)"mu", (ArgumentType)DoubleArgumentType.doubleArg()).then(endpoint.make(class_2170.method_9244((String)"sigma", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(endpoint.make(class_2170.method_9244((String)"lower_bound", (ArgumentType)IntegerArgumentType.integer((int)1)).then(endpoint.make((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"upper_bound", (ArgumentType)IntegerArgumentType.integer((int)1)), (Command<class_2168>)gaussianCmd, this::gaussianGen)), (Command<class_2168>)gaussianCmd, this::gaussianGen)), (Command<class_2168>)gaussianCmd, this::gaussianGen))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"triangular").executes(c -> this.triangularHelp((class_2168)c.getSource()))).then(class_2170.method_9244((String)"mode", (ArgumentType)DoubleArgumentType.doubleArg()).then(endpoint.make(class_2170.method_9244((String)"deviation", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(endpoint.make(class_2170.method_9244((String)"lower_bound", (ArgumentType)IntegerArgumentType.integer((int)1)).then(endpoint.make((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"upper_bound", (ArgumentType)IntegerArgumentType.integer((int)1)), (Command<class_2168>)triangularCmd, this::triangularGen)), (Command<class_2168>)triangularCmd, this::triangularGen)), (Command<class_2168>)triangularCmd, this::triangularGen)))));
    }

    private static Optional<Integer> getOptionalInteger(CommandContext<?> c, String name) {
        try {
            return Optional.of(IntegerArgumentType.getInteger(c, (String)name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private EntityPlayerActionPack.Action actionFromRandomGen(RandomGen gen) {
        EntityPlayerActionPack.Action action = EntityPlayerActionPack.Action.interval((int)gen.generateRandomInterval());
        ((IEntityPlayerActionPackAction)action).setIntervalRandomGenerator$TISCM(gen);
        return action;
    }

    private int randomlyHelp(class_2168 source) {
        Messenger.tell(source, this.tr("root.help", new Object[0]));
        return 0;
    }

    private int simulateRun(CommandContext<class_2168> c, RandomGen gen) {
        long now;
        int CHAR_COUNT = 40;
        int MIN_N = 10000;
        int MAX_N = 1000000;
        long MAX_MILLI = 500L;
        class_2168 source = (class_2168)c.getSource();
        Int2IntOpenHashMap counter = new Int2IntOpenHashMap();
        int n = 0;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000 && (i < 10000 || i % 100 != 0 || (now = System.currentTimeMillis()) - start <= 500L); ++i) {
            counter.addTo(gen.generateRandomInterval(), 1);
            ++n;
        }
        int maxCount = counter.values().stream().mapToInt(x -> x).max().orElse(1);
        int maxKeyWidth = counter.keySet().stream().mapToInt(x -> String.valueOf(x).length()).max().orElse(3);
        Messenger.tell(source, Messenger.click(this.tr("simulate.command", c.getInput()), Messenger.ClickEvents.suggestCommand(c.getInput())));
        Messenger.tell(source, this.tr("simulate.samples", n));
        Messenger.tell(source, Messenger.formatting(this.tr("simulate.divider", new Object[0]), class_124.field_1080));
        int finalN = n;
        counter.int2IntEntrySet().stream().sorted(Comparator.comparing(Int2IntMap.Entry::getIntKey)).forEach(e -> {
            String fmt = "%" + maxKeyWidth + "d %5.1f%% %s";
            Messenger.tell(source, Messenger.s(String.format(fmt, e.getIntKey(), 100.0 * (double)e.getIntValue() / (double)finalN, Strings.repeat((String)"#", (int)(40 * e.getIntValue() / maxCount)))));
        });
        Messenger.tell(source, Messenger.formatting(this.tr("simulate.divider", new Object[0]), class_124.field_1080));
        return n;
    }

    private int uniformHelp(class_2168 source) {
        Messenger.tell(source, this.tr("uniform.help", new Object[0]));
        return 0;
    }

    private RandomGen uniformGen(CommandContext<class_2168> c) {
        int lower = IntegerArgumentType.getInteger(c, (String)"min");
        int upper = IntegerArgumentType.getInteger(c, (String)"max");
        upper = Math.max(lower, upper);
        return new UniformGen(lower, upper);
    }

    private EntityPlayerActionPack.Action uniformImpl(CommandContext<class_2168> c, boolean showDeprecation) {
        if (showDeprecation) {
            Messenger.tell((class_2168)c.getSource(), Messenger.s((Object)this.tr("root.uniform_deprecation", new Object[0]), class_124.field_1079));
        }
        return this.actionFromRandomGen(this.uniformGen(c));
    }

    private int poissonHelp(class_2168 source) {
        Messenger.tell(source, this.tr("poisson.help", new Object[0]));
        return 0;
    }

    private RandomGen poissonGen(CommandContext<class_2168> c) throws CommandSyntaxException {
        double origin = DoubleArgumentType.getDouble(c, (String)"origin");
        double maxima = DoubleArgumentType.getDouble(c, (String)"maxima");
        int upper = RandomizedActionIntervalCommand.getOptionalInteger(c, "upper_bound").orElse(Integer.MAX_VALUE);
        double lambda = maxima - origin;
        if (lambda < 0.0) {
            throw new SimpleCommandExceptionType((Message)this.tr("poisson.large_origin", new Object[0])).create();
        }
        RandomGen gen = lambda <= 50.0 ? new PoissonGen(origin, lambda) : new RangeLimitedGen(new GaussianGen(origin + lambda, Math.sqrt(lambda)), (int)Math.round(origin), Integer.MAX_VALUE);
        return new RangeLimitedGen(gen, Integer.MIN_VALUE, upper);
    }

    private EntityPlayerActionPack.Action poissonImpl(CommandContext<class_2168> c) throws CommandSyntaxException {
        return this.actionFromRandomGen(this.poissonGen(c));
    }

    private int gaussianHelp(class_2168 source) {
        Messenger.tell(source, this.tr("gaussian.help", new Object[0]));
        return 0;
    }

    private RandomGen gaussianGen(CommandContext<class_2168> c) {
        double mu = DoubleArgumentType.getDouble(c, (String)"mu");
        double sigma = DoubleArgumentType.getDouble(c, (String)"sigma");
        int lower = RandomizedActionIntervalCommand.getOptionalInteger(c, "lower_bound").orElse(Integer.MIN_VALUE);
        int upper = RandomizedActionIntervalCommand.getOptionalInteger(c, "upper_bound").orElse(Integer.MAX_VALUE);
        return new RangeLimitedGen(new GaussianGen(mu, sigma), lower, upper);
    }

    private EntityPlayerActionPack.Action gaussianImpl(CommandContext<class_2168> c) {
        return this.actionFromRandomGen(this.gaussianGen(c));
    }

    private int triangularHelp(class_2168 source) {
        Messenger.tell(source, this.tr("triangular.help", new Object[0]));
        return 0;
    }

    private RandomGen triangularGen(CommandContext<class_2168> c) {
        double mode = DoubleArgumentType.getDouble(c, (String)"mode");
        double deviation = DoubleArgumentType.getDouble(c, (String)"deviation");
        int lower = RandomizedActionIntervalCommand.getOptionalInteger(c, "lower_bound").orElse(Integer.MIN_VALUE);
        int upper = RandomizedActionIntervalCommand.getOptionalInteger(c, "upper_bound").orElse(Integer.MAX_VALUE);
        return new RangeLimitedGen(new TriangularGen(mode, deviation), lower, upper);
    }

    private EntityPlayerActionPack.Action triangularImpl(CommandContext<class_2168> c) {
        return this.actionFromRandomGen(this.triangularGen(c));
    }

    @FunctionalInterface
    private static interface EndpointCmdMaker {
        public ArgumentBuilder<class_2168, ?> make(ArgumentBuilder<class_2168, ?> var1, Command<class_2168> var2, RandomGenSupplier var3);
    }

    @FunctionalInterface
    private static interface RandomGenSupplier {
        public RandomGen get(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }
}

