/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.fakePlayerNameExtra;

import carpet.settings.ParsedRule;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.settings.validator.AbstractCheckerValidator;
import carpettisaddition.settings.validator.ValidationContext;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_2554;

public class FakePlayerNameExtraValidator
extends AbstractCheckerValidator<String> {
    private final Map<ParsedRule<?>, String> lastDangerousInput = Maps.newHashMap();

    @Override
    protected boolean validateContext(ValidationContext<String> ctx) {
        if (ctx.source == null || CarpetTISAdditionSettings.isLoadingRulesFromConfig) {
            return true;
        }
        if (!((String)ctx.inputValue).equals("#none") && !Pattern.matches("[a-zA-Z_0-9]{1,16}", (CharSequence)ctx.inputValue)) {
            Consumer<class_2554> messenger = msg -> Messenger.tell(ctx.source, Messenger.s((Object)msg.getString(), "r"));
            messenger.accept(FakePlayerNameExtraValidator.tr("fake_player_name_extra.warn.found", ctx.inputValue, ctx.ruleName()));
            if (!Objects.equals(this.lastDangerousInput.get(ctx.rule), ctx.inputValue)) {
                messenger.accept(FakePlayerNameExtraValidator.tr("fake_player_name_extra.warn.blocked", new Object[0]));
                this.lastDangerousInput.put(ctx.rule, (String)ctx.inputValue);
                return false;
            }
            messenger.accept(FakePlayerNameExtraValidator.tr("fake_player_name_extra.warn.applied", new Object[0]));
        }
        this.lastDangerousInput.remove(ctx.rule);
        return true;
    }

    @Override
    public class_2554 errorMessage(ValidationContext<String> ctx) {
        return FakePlayerNameExtraValidator.tr("fake_player_name_extra.message", new Object[0]);
    }
}

