/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging;

import carpet.logging.HUDLogger;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.commandblock.CommandBlockLogger;
import carpettisaddition.logging.loggers.damage.DamageLogger;
import carpettisaddition.logging.loggers.entity.ItemLogger;
import carpettisaddition.logging.loggers.entity.XPOrbLogger;
import carpettisaddition.logging.loggers.lifetime.LifeTimeHUDLogger;
import carpettisaddition.logging.loggers.lightqueue.LightQueueHUDLogger;
import carpettisaddition.logging.loggers.memory.MemoryHUDLogger;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingStandardCarpetLogger;
import carpettisaddition.logging.loggers.movement.MovementLogger;
import carpettisaddition.logging.loggers.phantom.PhantomLogger;
import carpettisaddition.logging.loggers.portalCreation.PortalCreationLogger;
import carpettisaddition.logging.loggers.raid.RaidLogger;
import carpettisaddition.logging.loggers.scounter.SupplierCounterHUDLogger;
import carpettisaddition.logging.loggers.ticket.TicketLogger;
import carpettisaddition.logging.loggers.tickwarp.TickWarpHUDLogger;
import carpettisaddition.logging.loggers.turtleegg.TurtleEggLogger;
import carpettisaddition.logging.loggers.wanderingTrader.WanderingTraderLogger;
import carpettisaddition.logging.loggers.xcounter.XpCounterHUDLogger;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;

public class TISAdditionLoggerRegistry {
    private static final List<Runnable> onRegisteredCallbacks = Lists.newArrayList();
    public static boolean __commandBlock;
    public static boolean __damage;
    public static boolean __item;
    public static boolean __lifetime;
    public static boolean __lightQueue;
    public static boolean __memory;
    public static boolean __microTiming;
    public static boolean __movement;
    public static boolean __phantom;
    public static boolean __portalCreation;
    public static boolean __raid;
    public static boolean __scounter;
    public static boolean __ticket;
    public static boolean __tickWarp;
    public static boolean __turtleEgg;
    public static boolean __wanderingTrader;
    public static boolean __xporb;
    public static boolean __xcounter;

    public static void registerLoggers() {
        TISAdditionLoggerRegistry.register(CommandBlockLogger.getInstance());
        TISAdditionLoggerRegistry.register(DamageLogger.getInstance());
        TISAdditionLoggerRegistry.register(ItemLogger.getInstance());
        TISAdditionLoggerRegistry.register(LifeTimeHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(LightQueueHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(MemoryHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(MicroTimingStandardCarpetLogger.getInstance());
        TISAdditionLoggerRegistry.register(MovementLogger.getInstance());
        TISAdditionLoggerRegistry.register(PhantomLogger.getInstance());
        TISAdditionLoggerRegistry.register(PortalCreationLogger.getInstance());
        TISAdditionLoggerRegistry.register(RaidLogger.getInstance());
        TISAdditionLoggerRegistry.register(SupplierCounterHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(TicketLogger.getInstance());
        TISAdditionLoggerRegistry.register(TickWarpHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(TurtleEggLogger.getInstance());
        TISAdditionLoggerRegistry.register(WanderingTraderLogger.getInstance());
        TISAdditionLoggerRegistry.register(XpCounterHUDLogger.getInstance());
        TISAdditionLoggerRegistry.register(XPOrbLogger.getInstance());
        onRegisteredCallbacks.forEach(Runnable::run);
    }

    private static void register(AbstractLogger logger) {
        TISAdditionLoggerRegistry.register(logger.createCarpetLogger());
    }

    private static void register(Logger logger) {
        LoggerRegistry.registerLogger((String)logger.getLogName(), (Logger)logger);
    }

    public static Field getLoggerField(String logName) {
        try {
            return TISAdditionLoggerRegistry.class.getField("__" + logName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Failed to get logger field \"%s\" @ %s", logName, "Carpet TIS Addition"));
        }
    }

    public static Logger standardLogger(String logName, String def, String[] options) {
        return new Logger(TISAdditionLoggerRegistry.getLoggerField(logName), logName, def, options);
    }

    public static HUDLogger standardHUDLogger(String logName, String def, String[] options) {
        return new HUDLogger(TISAdditionLoggerRegistry.getLoggerField(logName), logName, def, options);
    }

    public static void addLoggerRegisteredCallback(Runnable callback) {
        onRegisteredCallbacks.add(callback);
    }
}

