/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.damage;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.damage.DamageContext;
import carpettisaddition.logging.loggers.damage.OptionParser;
import carpettisaddition.logging.loggers.damage.interfaces.DamageLoggerTarget;
import carpettisaddition.logging.loggers.damage.modifyreasons.Modification;
import carpettisaddition.logging.loggers.damage.modifyreasons.ModifyReason;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2554;
import org.jetbrains.annotations.Nullable;

public class DamageLogger
extends AbstractLogger {
    public static final String NAME = "damage";
    private static final DamageLogger INSTANCE = new DamageLogger();

    private DamageLogger() {
        super(NAME, false);
    }

    public static DamageLogger getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String[] getSuggestedLoggingOption() {
        return new String[]{"all", "players", "me", "->creeper", "vex->", "me->zombie", "hotFloor->zombie", "Steve", "@e[distance=..10]"};
    }

    public static boolean isLoggerActivated() {
        return TISAdditionLoggerRegistry.__damage;
    }

    public static void create(class_1309 entity, class_1282 source, float amount) {
        DamageLoggerTarget damageLoggerTarget;
        if (DamageLogger.isLoggerActivated() && !(damageLoggerTarget = (DamageLoggerTarget)entity).getDamageTracker().isPresent()) {
            DamageLogger damageLogger = DamageLogger.getInstance();
            Objects.requireNonNull(damageLogger);
            damageLoggerTarget.setDamageTracker(damageLogger.new Tracker(entity, source, amount));
        }
    }

    public class Tracker {
        private final class_1309 entity;
        private final float initialHealth;
        private final class_1282 damageSource;
        private final float initialAmount;
        private float currentAmount;
        private final List<Modification> modificationList = Lists.newArrayList();
        private boolean valid;

        public Tracker(class_1309 entity, class_1282 damageSource, float initialAmount) {
            this.entity = entity;
            this.initialHealth = entity.method_6032();
            this.damageSource = damageSource;
            this.initialAmount = initialAmount;
            this.currentAmount = initialAmount;
            this.valid = true;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void modifyDamage(float newAmount, ModifyReason reason) {
            boolean isFire = this.damageSource.method_5534();
            if (isFire && (this.entity.method_5753() || this.entity.method_6059(class_1294.field_5918))) {
                this.valid = false;
                return;
            }
            if (newAmount != this.currentAmount) {
                this.modificationList.add(new Modification(this.currentAmount, newAmount, reason));
                this.currentAmount = newAmount;
            }
            if (reason == ModifyReason.INVULNERABLE) {
                this.valid = false;
            }
        }

        private class_2554[] verifyAndProduceMessage(String option, class_1657 player, DamageContext ctx, Supplier<class_2554[]> messageFuture) {
            OptionParser parser = new OptionParser(option);
            if (parser.accepts(player, ctx)) {
                return messageFuture.get();
            }
            return null;
        }

        private class_2554 getAmountText(@Nullable String style, float amount) {
            String display = String.format("%.2f", Float.valueOf(amount));
            String detail = String.format("%.6f", Float.valueOf(amount));
            return Messenger.fancy(style, Messenger.s(display), Messenger.s(detail), Messenger.ClickEvents.suggestCommand(detail));
        }

        public void flush(float finalAmount, float remainingHealth) {
            if (!DamageLogger.isLoggerActivated() || !this.isValid()) {
                return;
            }
            this.valid = false;
            class_1297 attacker = this.damageSource.method_5529();
            class_1297 source = this.damageSource.method_5526();
            class_1309 target = this.entity;
            DamageContext ctx = new DamageContext(this.damageSource, attacker, (class_1297)target);
            DamageLogger.this.log((option, player) -> this.verifyAndProduceMessage(option, player, ctx, () -> {
                ArrayList lines = Lists.newArrayList();
                lines.add(Messenger.s(" "));
                class_2554 targetName = Messenger.entity("b", (class_1297)target);
                ArrayList sourceHoverTextList = Lists.newArrayList();
                if (source != null) {
                    sourceHoverTextList.add(Messenger.c(DamageLogger.this.tr("source", new Object[0]), "w : ", Messenger.entity(source)));
                }
                if (attacker != null) {
                    sourceHoverTextList.add(Messenger.c(DamageLogger.this.tr("attacker", new Object[0]), "w : ", Messenger.entity(attacker)));
                }
                lines.add(DamageLogger.this.tr("header_message", new Object[]{targetName, this.getAmountText("r", this.initialAmount), Messenger.fancy("w", Messenger.s(this.damageSource.method_5525()), sourceHoverTextList.isEmpty() ? null : Messenger.joinLines(sourceHoverTextList), attacker != null ? Messenger.ClickEvents.suggestCommand(TextUtils.tp(attacker)) : null), this.getAmountText(null, this.initialHealth)}));
                for (Modification modification : this.modificationList) {
                    float oldAmount = modification.getOldAmount();
                    float newAmount = modification.getNewAmount();
                    float delta = Math.abs(newAmount - oldAmount);
                    String sig = newAmount > oldAmount ? "+" : "-";
                    String radio = oldAmount != 0.0f ? String.format("%.1f%%", Float.valueOf(100.0f * delta / oldAmount)) : "N/A%";
                    lines.add(Messenger.c("g  - ", this.getAmountText("r", oldAmount), "g  -> ", this.getAmountText(newAmount > oldAmount ? "r" : "d", newAmount), String.format("g  (%s", sig), Messenger.hover(this.getAmountText("g", delta), Messenger.s(String.format("%s%.6f", sig, Float.valueOf(delta)))), String.format("g , %s%s)", sig, radio), DamageLogger.this.tr("due_to", new Object[]{modification.getReason().toText()})));
                }
                lines.add(DamageLogger.this.tr("footer_message", new Object[]{targetName, this.getAmountText(finalAmount > 0.0f ? "r" : "w", finalAmount), this.getAmountText(remainingHealth > 0.0f ? "l" : "r", remainingHealth)}));
                return (class_2554[])lines.stream().map(xva$0 -> Messenger.c(xva$0)).toArray(class_2554[]::new);
            }));
        }
    }
}

