/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.lightqueue;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractHUDLogger;
import carpettisaddition.logging.loggers.lightqueue.IServerLightingProvider;
import carpettisaddition.logging.loggers.lightqueue.RecordedData;
import carpettisaddition.logging.loggers.lightqueue.WindowedDataRecorder;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Maps;
import java.util.Deque;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2554;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3568;
import net.minecraft.server.MinecraftServer;

public class LightQueueHUDLogger
extends AbstractHUDLogger {
    public static final String NAME = "lightQueue";
    private static final LightQueueHUDLogger INSTANCE = new LightQueueHUDLogger();
    private final Map<class_3218, WindowedDataRecorder> dataMap = Maps.newHashMap();
    private final Map<class_2960, class_3218> nameToWorldMap = Maps.newHashMap();

    public LightQueueHUDLogger() {
        super(NAME, false);
    }

    public static LightQueueHUDLogger getInstance() {
        return INSTANCE;
    }

    public void attachServer(MinecraftServer minecraftServer) {
        this.dataMap.clear();
        this.nameToWorldMap.clear();
        for (class_3218 world : minecraftServer.method_3738()) {
            this.dataMap.put(world, new WindowedDataRecorder());
            this.nameToWorldMap.put(DimensionWrapper.of((class_1937)world).getIdentifier(), world);
        }
    }

    @Override
    public String[] getSuggestedLoggingOption() {
        return new String[]{"dynamic", "overworld", "the_nether", "the_end"};
    }

    public void tick() {
        this.nameToWorldMap.values().forEach(world -> {
            class_3568 lightingProvider = world.method_22336();
            if (lightingProvider instanceof IServerLightingProvider) {
                IServerLightingProvider iProvider = (IServerLightingProvider)lightingProvider;
                long enqueuedCount = iProvider.getEnqueuedTaskCountAndClean();
                long executedCount = iProvider.getExecutedTaskCountAndClean();
                if (TISAdditionLoggerRegistry.__lightQueue) {
                    this.dataMap.get(world).add(new RecordedData(enqueuedCount, executedCount, iProvider.getQueueSize()));
                } else {
                    this.dataMap.get(world).clear();
                }
            }
        });
    }

    @Override
    public class_2554[] onHudUpdate(String option, class_1657 playerEntity) {
        class_1937 playerWorld = EntityUtils.getEntityWorld((class_1297)playerEntity);
        if (!(playerWorld instanceof class_3218)) {
            return new class_2554[]{Messenger.s("not ServerWorld")};
        }
        class_2960 optionId = class_2960.method_12829((String)option);
        class_3218 serverWorld = this.nameToWorldMap.getOrDefault(optionId, (class_3218)playerWorld);
        WindowedDataRecorder recorder = this.dataMap.get(serverWorld);
        Deque<RecordedData> deque = recorder.getQueue();
        long enqueuedCount = recorder.getEnqueuedCount();
        long executedCount = recorder.getExecutedCount();
        long queueSize = deque.isEmpty() ? 0L : deque.getLast().queueSize;
        double enqueueSpeed = (double)enqueuedCount / (double)deque.size();
        double executeSpeed = (double)executedCount / (double)deque.size();
        double increaseSpeed = enqueueSpeed - executeSpeed;
        class_2554 header = Messenger.c("g LQ(", Messenger.getColoredDimensionSymbol(DimensionWrapper.of((class_1937)serverWorld)), "g ) ");
        return new class_2554[]{Messenger.c(header, String.format("%s%.1f", increaseSpeed >= 0.0 ? "e +" : "n ", increaseSpeed), "g /gt", "g  S: ", String.format("q %d", queueSize), "g  T: ", String.format("p %.1f", executeSpeed > 0.0 ? (double)queueSize / executeSpeed : 0.0), "g gt"), Messenger.c("g Light I", "f /", "g O", "f : ", String.format("g %.1f", enqueueSpeed), "f /", String.format("g %.1f", executeSpeed))};
    }
}

