/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.marker;

import carpet.script.utils.ShapeDispatcher;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarker;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerType;
import carpettisaddition.logging.loggers.microtiming.marker.StorageKey;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class MicroTimingMarkerManager
extends TranslationContext {
    private static final MicroTimingMarkerManager INSTANCE = new MicroTimingMarkerManager();
    private final Map<StorageKey, MicroTimingMarker> markers = Maps.newHashMap();

    public MicroTimingMarkerManager() {
        super(MicroTimingLoggerManager.TRANSLATOR.getDerivedTranslator("marker"));
    }

    public static MicroTimingMarkerManager getInstance() {
        return INSTANCE;
    }

    public int clear() {
        this.cleanMarkersForAll(marker -> true);
        int size = this.markers.size();
        this.markers.clear();
        return size;
    }

    private static boolean checkServerSide(class_1657 playerEntity) {
        class_1937 playerWorld = EntityUtils.getEntityWorld((class_1297)playerEntity);
        return playerEntity instanceof class_3222 && !playerWorld.method_8608() && playerWorld instanceof class_3218;
    }

    private void removeMarker(MicroTimingMarker marker) {
        marker.cleanShapeToAll();
        this.markers.remove(marker.getStorageKey());
    }

    private void addMarker(MicroTimingMarker marker) {
        marker.sendShapeToAll();
        StorageKey key = marker.getStorageKey();
        MicroTimingMarker existedMarker = this.markers.get(key);
        if (existedMarker != null) {
            this.removeMarker(existedMarker);
        }
        this.markers.put(marker.getStorageKey(), marker);
    }

    public void addMarker(class_1657 playerEntity, class_2338 blockPos, class_1767 color, @Nullable class_2554 name) {
        if (MicroTimingMarkerManager.checkServerSide(playerEntity)) {
            StorageKey key = new StorageKey(EntityUtils.getEntityWorld((class_1297)playerEntity), blockPos);
            MicroTimingMarker existedMarker = this.markers.get(key);
            boolean removeExistedMarker = false;
            boolean createNewMarker = false;
            if (existedMarker != null) {
                if (existedMarker.color == color) {
                    if (existedMarker.rollMarkerType()) {
                        Messenger.reminder(playerEntity, this.tr("on_type_switch", existedMarker.getMarkerType().getFancyString()));
                    } else {
                        removeExistedMarker = true;
                    }
                } else {
                    removeExistedMarker = true;
                    createNewMarker = true;
                }
            } else {
                createNewMarker = true;
            }
            if (removeExistedMarker) {
                this.removeMarker(existedMarker);
                Messenger.reminder(playerEntity, this.tr("on_unmark", existedMarker.toFullText()));
            }
            if (createNewMarker) {
                MicroTimingMarker newMarker = new MicroTimingMarker((class_3218)EntityUtils.getEntityWorld((class_1297)playerEntity), blockPos, color, name);
                this.addMarker(newMarker);
                Messenger.reminder(playerEntity, this.tr("on_mark", newMarker.toFullText()));
            }
        }
    }

    public Optional<class_1767> getColor(class_1937 world, class_2338 blockPos, MicroTimingMarkerType requiredMarkerType) {
        MicroTimingMarker marker = this.markers.get(new StorageKey(world, blockPos));
        if (marker == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(marker.getMarkerType().ordinal() >= requiredMarkerType.ordinal() ? marker.color : null);
    }

    public Optional<String> getMarkerName(class_1937 world, class_2338 blockPos) {
        return Optional.ofNullable(this.markers.get(new StorageKey(world, blockPos))).map(MicroTimingMarker::getMarkerNameString);
    }

    private void sendMarkersForPlayerInner(List<class_3222> playerList, Predicate<MicroTimingMarker> markerPredicate, boolean display) {
        if (!playerList.isEmpty() && !this.markers.isEmpty()) {
            ShapeDispatcher.sendShape(playerList, this.markers.values().stream().filter(markerPredicate).flatMap(marker -> marker.getShapeDataList(display).stream()).collect(Collectors.toList()));
        }
    }

    public void sendAllMarkersForPlayer(class_3222 player) {
        this.sendMarkersForPlayerInner(Collections.singletonList(player), marker -> true, true);
    }

    public void cleanAllMarkersForPlayer(class_3222 player) {
        this.sendMarkersForPlayerInner(Collections.singletonList(player), marker -> true, false);
    }

    public void sendMarkersForAll(Predicate<MicroTimingMarker> markerPredicate) {
        this.sendMarkersForPlayerInner(MicroTimingUtil.getSubscribedPlayers(), markerPredicate, true);
    }

    public void cleanMarkersForAll(Predicate<MicroTimingMarker> markerPredicate) {
        this.sendMarkersForPlayerInner(MicroTimingUtil.getSubscribedPlayers(), markerPredicate, false);
    }

    public void tick() {
        if (!CarpetTISAdditionSettings.microTiming) {
            return;
        }
        this.sendMarkersForAll(marker -> marker.tickCounter % 100L == 0L);
        this.markers.values().forEach(marker -> ++marker.tickCounter);
    }

    public boolean tweakMarkerMobility(class_1657 playerEntity, class_2338 blockPos) {
        StorageKey key;
        MicroTimingMarker marker;
        if (MicroTimingMarkerManager.checkServerSide(playerEntity) && (marker = this.markers.get(key = new StorageKey(EntityUtils.getEntityWorld((class_1297)playerEntity), blockPos))) != null) {
            boolean nextState = !marker.isMovable();
            marker.setMovable(nextState);
            Messenger.reminder(playerEntity, this.tr(nextState ? "on_mobility_true" : "on_mobility_false", marker.toShortText()));
            return true;
        }
        return false;
    }

    public void moveMarker(class_1937 world, class_2338 blockPos, class_2350 direction) {
        MicroTimingMarker marker = this.markers.get(new StorageKey(world, blockPos));
        if (marker != null && marker.isMovable()) {
            this.removeMarker(marker);
            this.addMarker(marker.offsetCopy(direction));
        }
    }
}

