/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.tweaks.loggerRestriction;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.settings.ParsedRule;
import carpet.settings.Validator;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.helpers.carpet.loggerRestriction.CarpetLoggerRestriction;
import carpettisaddition.helpers.carpet.loggerRestriction.ruleSwitch.LoggerSwitchRuleCommon;
import carpettisaddition.helpers.carpet.loggerRestriction.ruleSwitch.LoggerSwitchValidator;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParsedRule.class})
public abstract class ParsedRuleMixin<T> {
    @Shadow(remap=false)
    @Final
    public String name;
    @Shadow(remap=false)
    @Final
    public ImmutableList<String> categories;
    @Shadow(remap=false)
    @Final
    @Mutable
    public ImmutableList<String> options;
    @Shadow(remap=false)
    @Final
    public Class<T> type;
    @Shadow(remap=false)
    @Final
    public List<Validator<T>> validators;
    @Shadow(remap=false)
    public boolean isStrict;

    @Shadow(remap=false)
    public abstract T get();

    @Inject(method={"<init>"}, slice={@Slice(from=@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;of()Lcom/google/common/collect/ImmutableList;"))}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;isEmpty()Z", ordinal=0)}, remap=false)
    private void loggerRestriction_ruleTweak(CallbackInfo ci) {
        if (this.categories.contains((Object)"TIS") && this.categories.contains((Object)"logger")) {
            if (this.type != String.class) {
                CarpetTISAdditionMod.LOGGER.warn("TISCM logger switch rule {} is not a string, found type {}", (Object)this.name, this.type);
                return;
            }
            String SUFFIX = "logger";
            if (!this.name.startsWith("logger")) {
                CarpetTISAdditionMod.LOGGER.warn("TISCM logger switch rule {} has invalid name", (Object)this.name);
                return;
            }
            String ruleNameRemaining = this.name.substring("logger".length());
            String loggerName = !ruleNameRemaining.isEmpty() ? ruleNameRemaining.substring(0, 1).toLowerCase() + ruleNameRemaining.substring(1) : ruleNameRemaining;
            this.isStrict = false;
            this.validators.add(new LoggerSwitchValidator());
            this.options = LoggerSwitchRuleCommon.OPTIONS;
            TISAdditionLoggerRegistry.addLoggerRegisteredCallback(() -> {
                Logger logger = LoggerRegistry.getLogger((String)loggerName);
                if (logger == null) {
                    CarpetTISAdditionMod.LOGGER.warn("TISCM logger switch rule {} has its logger {} not found", (Object)this.name, (Object)loggerName);
                    return;
                }
                CarpetLoggerRestriction.addLoggerRuleSwitch(logger, this.name, () -> (String)this.get());
                CarpetTISAdditionMod.LOGGER.debug("TISCM logger switch rule {} enabled for logger {}", (Object)this.name, (Object)loggerName);
            });
        }
    }
}

