/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.command;

import carpettisaddition.utils.command.BuilderFactory;
import carpettisaddition.utils.command.BuilderProcessor;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import java.util.function.Predicate;

public class BuilderDefinition<S, T extends ArgumentBuilder<S, ?>> {
    private final BuilderFactory<T> factory;
    private final List<BuilderProcessor<T>> processors = Lists.newArrayList();

    public BuilderDefinition(BuilderFactory<T> factory) {
        this.factory = factory;
    }

    ArgumentBuilder<S, ?> createBuilder(String nodeName) {
        ArgumentBuilder builder = (ArgumentBuilder)this.factory.create(nodeName);
        for (BuilderProcessor<ArgumentBuilder> builderProcessor : this.processors) {
            builderProcessor.process(builder);
        }
        return builder;
    }

    public BuilderDefinition<S, T> postProcess(BuilderProcessor<T> postProcessor) {
        this.processors.add(postProcessor);
        return this;
    }

    public BuilderDefinition<S, T> then(ArgumentBuilder<S, ?> argument) {
        return this.postProcess(node -> node.then(argument));
    }

    public BuilderDefinition<S, T> then(CommandNode<S> argument) {
        return this.postProcess(node -> node.then(argument));
    }

    public BuilderDefinition<S, T> requires(Predicate<S> requirement) {
        return this.postProcess(node -> node.requires(requirement));
    }

    public BuilderDefinition<S, T> suggests(SuggestionProvider<S> provider) {
        return this.postProcess(node -> {
            if (!(node instanceof RequiredArgumentBuilder)) {
                throw new IllegalArgumentException("cannot apply suggests on a " + node);
            }
            ((RequiredArgumentBuilder)node).suggests(provider);
        });
    }
}

