/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.sleep;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5250;

public class SleepCommand
extends AbstractCommand {
    private static final String NAME = "sleep";
    private static final SleepCommand INSTANCE = new SleepCommand();

    private SleepCommand() {
        super(NAME);
    }

    public static SleepCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        RequiredArgumentBuilder durationNode = class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)60000));
        for (TimeUnit timeUnit : TimeUnit.values()) {
            durationNode.then(class_2170.method_9247((String)timeUnit.name).executes(c -> this.doLag((class_2168)c.getSource(), timeUnit, IntegerArgumentType.getInteger((CommandContext)c, (String)"duration"))));
        }
        context.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(s -> CarpetModUtil.canUseCommand(s, CarpetTISAdditionSettings.commandSleep))).executes(c -> this.showHelp((class_2168)c.getSource()))).then((ArgumentBuilder)durationNode));
    }

    private int showHelp(class_2168 source) {
        class_5250 usage = Messenger.c("w /sleep", "g  <", "w duration", "g > (", Messenger.join(Messenger.s((Object)"|", class_124.field_1080), (class_5250[])Arrays.stream(TimeUnit.values()).map(tu -> Messenger.s(tu.name)).toArray(class_5250[]::new)), "g )");
        Messenger.tell(source, this.tr("help", new Object[0]));
        Messenger.tell(source, this.tr("usage", usage));
        Messenger.tell(source, Messenger.c(Messenger.formatting(this.tr("warning_header", new Object[0]), class_124.field_1067), Messenger.s(": "), this.tr("warning_content", new Object[0])));
        return 0;
    }

    private int doLag(class_2168 source, TimeUnit timeUnit, int duration) {
        try {
            timeUnit.action.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static enum TimeUnit {
        SECOND("s", duration -> Thread.sleep(duration * 1000L)),
        MILLI_SECOND("ms", duration -> Thread.sleep(duration)),
        MICRO_SECOND("us", duration -> Thread.sleep(duration / 1000L, (int)(duration % 1000L)));

        public final String name;
        public final SleepAction action;

        private TimeUnit(String name, SleepAction action) {
            this.name = name;
            this.action = action;
        }

        @FunctionalInterface
        static interface SleepAction {
            public void sleep(long var1) throws InterruptedException;
        }
    }
}

