/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.message;

import carpettisaddition.logging.loggers.microtiming.message.IndentedMessage;
import carpettisaddition.logging.loggers.microtiming.message.MessageTreeNode;
import carpettisaddition.logging.loggers.microtiming.message.MessageType;
import carpettisaddition.logging.loggers.microtiming.message.MicroTimingMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class MessageList {
    private final List<MessageTreeNode> messageTrees = Lists.newArrayList();
    private MessageTreeNode currentNode;

    public synchronized void clear() {
        this.messageTrees.clear();
        this.currentNode = null;
    }

    public synchronized boolean isEmpty() {
        return this.messageTrees.isEmpty();
    }

    public synchronized List<IndentedMessage> flush() {
        ArrayList list = Lists.newArrayList();
        for (MessageTreeNode tree : this.messageTrees) {
            list.addAll(tree.flush());
        }
        this.clear();
        return list;
    }

    public synchronized void addMessageAndIndent(MicroTimingMessage message) {
        this.currentNode = new MessageTreeNode(this.currentNode, message);
        if (this.currentNode.getParent() == null) {
            this.messageTrees.add(this.currentNode);
        }
        if (message.getMessageType() == MessageType.ATOM) {
            this.currentNode = this.currentNode.getParent();
        }
    }

    public synchronized void addMessageAndUnIndent(MicroTimingMessage message) {
        if (this.currentNode != null) {
            this.currentNode.setQuitMessage(message);
            this.currentNode = this.currentNode.getParent();
        }
    }
}

