/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.filter.EntityFilterManager;
import carpettisaddition.commands.lifetime.recorder.LifetimeRecorder;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.commands.lifetime.utils.SpecificDetailMode;
import carpettisaddition.utils.CarpetModUtil;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import org.jetbrains.annotations.Nullable;

public class LifeTimeCommand
extends AbstractCommand {
    public static final String NAME = "lifetime";
    private static final LifeTimeCommand INSTANCE = new LifeTimeCommand();

    private LifeTimeCommand() {
        super(NAME);
    }

    public static LifeTimeCommand getInstance() {
        return INSTANCE;
    }

    private int checkEntityTypeThen(class_2168 source, @Nullable String entityTypeName, Consumer<class_1299<?>> entityTypeConsumer) {
        class_1299<?> entityType;
        if (entityTypeName == null) {
            entityType = null;
        } else {
            Optional<class_1299<?>> optionalEntityType = LifeTimeTrackerUtil.getEntityTypeFromName(entityTypeName);
            if (optionalEntityType.isPresent()) {
                entityType = optionalEntityType.get();
            } else {
                LifeTimeTracker.getInstance().sendUnknownEntity(source, entityTypeName);
                return 0;
            }
        }
        entityTypeConsumer.accept(entityType);
        return 1;
    }

    private int setEntityFilter(class_2168 source, @Nullable String entityTypeName, class_2300 selector) {
        return this.checkEntityTypeThen(source, entityTypeName, entityType -> EntityFilterManager.getInstance().setEntityFilter(source, (class_1299<?>)entityType, selector));
    }

    private int printEntityFilter(class_2168 source, @Nullable String entityTypeName) {
        return this.checkEntityTypeThen(source, entityTypeName, entityType -> EntityFilterManager.getInstance().displayFilter(source, (class_1299<?>)entityType));
    }

    private ArgumentBuilder<class_2168, ?> createFilterNode(ArgumentBuilder<class_2168, ?> node, Function<CommandContext<class_2168>, @Nullable String> entityTypeNameSupplier) {
        return node.executes(c -> this.printEntityFilter((class_2168)c.getSource(), (String)entityTypeNameSupplier.apply(c))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"filter", (ArgumentType)class_2186.method_9306()).executes(c -> this.setEntityFilter((class_2168)c.getSource(), (String)entityTypeNameSupplier.apply(c), (class_2300)c.getArgument("filter", class_2300.class))))).then(class_2170.method_9247((String)"clear").executes(c -> this.setEntityFilter((class_2168)c.getSource(), (String)entityTypeNameSupplier.apply(c), null)));
    }

    private ArgumentBuilder<class_2168, ?> realtimeActionNode(ArgumentBuilder<class_2168, ?> node, BiFunction<CommandContext<class_2168>, Boolean, Integer> action) {
        return node.executes(c -> (Integer)action.apply(c, false)).then(class_2170.method_9247((String)"realtime").executes(c -> (Integer)action.apply(c, true)));
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        String entityTypeArg = "entity_type";
        String detailModeArg = "detail";
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(player -> CarpetModUtil.canUseCommand(player, CarpetTISAdditionSettings.commandLifeTime))).executes(c -> LifeTimeTracker.getInstance().showHelp((class_2168)c.getSource()))).then(LifeTimeTracker.getInstance().getTrackingArgumentBuilder())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"filter").executes(c -> EntityFilterManager.getInstance().displayAllFilters((class_2168)c.getSource()))).then(this.createFilterNode((ArgumentBuilder<class_2168, ?>)class_2170.method_9247((String)"global"), c -> null))).then(this.createFilterNode((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(LifeTimeTrackerUtil.getEntityTypeDescriptorStream(), (SuggestionsBuilder)b)), c -> StringArgumentType.getString((CommandContext)c, (String)"entity_type"))))).then(this.realtimeActionNode(class_2170.method_9244((String)"entity_type", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(LifeTimeTracker.getInstance().getAvailableEntityType(), (SuggestionsBuilder)b)).then(this.realtimeActionNode((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"detail", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9253((String[])SpecificDetailMode.getSuggestion(), (SuggestionsBuilder)b)), (c, realtime) -> LifeTimeTracker.getInstance().printTrackingResultSpecific((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"entity_type"), StringArgumentType.getString((CommandContext)c, (String)"detail"), (boolean)realtime))), (c, realtime) -> LifeTimeTracker.getInstance().printTrackingResultSpecific((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"entity_type"), null, (boolean)realtime)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"recorder").executes(c -> LifetimeRecorder.getInstance().showStatus((class_2168)c.getSource()))).then(class_2170.method_9247((String)"status").executes(c -> LifetimeRecorder.getInstance().showStatus((class_2168)c.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(LifetimeRecorder.getInstance()::hasPermission)).executes(c -> LifetimeRecorder.getInstance().reloadConfig((class_2168)c.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enable").requires(LifetimeRecorder.getInstance()::hasPermission)).executes(c -> LifetimeRecorder.getInstance().enableRecording((class_2168)c.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(LifetimeRecorder.getInstance()::hasPermission)).executes(c -> LifetimeRecorder.getInstance().disableRecording((class_2168)c.getSource()))))).then(class_2170.method_9247((String)"help").executes(c -> LifeTimeTracker.getInstance().showHelp((class_2168)c.getSource())));
        context.dispatcher.register(builder);
    }
}

