/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.microtiming.events.blockupdate;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.BlockUpdateType;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ChainRestrictedNeighborUpdaterMixins {

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(targets={"net.minecraft.world.block.ChainRestrictedNeighborUpdater$StateReplacementEntry"})
    public static class StateReplacementEntryMixin {
        @Shadow
        @Final
        private class_2680 comp_667;
        @Shadow
        @Final
        private class_2338 comp_669;

        @Inject(method={"update"}, at={@At(value="HEAD")})
        private void startStateUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_669, this.comp_667.method_26204(), BlockUpdateType.SINGLE_STATE_UPDATE, null, EventType.ACTION_START);
        }

        @Inject(method={"update"}, at={@At(value="TAIL")})
        private void endStateUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_669, this.comp_667.method_26204(), BlockUpdateType.SINGLE_STATE_UPDATE, null, EventType.ACTION_END);
        }
    }

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(targets={"net.minecraft.world.block.ChainRestrictedNeighborUpdater$SixWayEntry"})
    public static class SixWayEntryMixin {
        @Shadow
        @Final
        private class_2248 field_37835;
        @Shadow
        @Final
        private class_2338 field_37834;
        @Shadow
        @Final
        private class_2350 field_37836;
        private boolean hasTriggeredStartEvent$TISCM = false;

        @Inject(method={"update"}, at={@At(value="HEAD")})
        private void startBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            if (!this.hasTriggeredStartEvent$TISCM) {
                this.hasTriggeredStartEvent$TISCM = true;
                if (this.field_37836 == null) {
                    MicroTimingLoggerManager.onBlockUpdate(world, this.field_37834, this.field_37835, BlockUpdateType.BLOCK_UPDATE, null, EventType.ACTION_START);
                } else {
                    MicroTimingLoggerManager.onBlockUpdate(world, this.field_37834, this.field_37835, BlockUpdateType.BLOCK_UPDATE_EXCEPT, this.field_37836, EventType.ACTION_START);
                }
            }
        }

        @Inject(method={"update"}, at={@At(value="TAIL")})
        private void endBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            if (!((Boolean)cir.getReturnValue()).booleanValue()) {
                if (this.field_37836 == null) {
                    MicroTimingLoggerManager.onBlockUpdate(world, this.field_37834, this.field_37835, BlockUpdateType.BLOCK_UPDATE, null, EventType.ACTION_END);
                } else {
                    MicroTimingLoggerManager.onBlockUpdate(world, this.field_37834, this.field_37835, BlockUpdateType.BLOCK_UPDATE_EXCEPT, this.field_37836, EventType.ACTION_END);
                }
            }
        }
    }

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(targets={"net.minecraft.world.block.ChainRestrictedNeighborUpdater$StatefulEntry"})
    public static class StatefulEntryMixin {
        @Shadow
        @Final
        private class_2248 comp_586;
        @Shadow
        @Final
        private class_2338 comp_585;

        @Inject(method={"update"}, at={@At(value="HEAD")})
        private void startBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_585, this.comp_586, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_START);
        }

        @Inject(method={"update"}, at={@At(value="TAIL")})
        private void endBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_585, this.comp_586, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_END);
        }
    }

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(targets={"net.minecraft.world.block.ChainRestrictedNeighborUpdater$SimpleEntry"})
    public static class SimpleEntryMixin {
        @Shadow
        @Final
        private class_2248 comp_590;
        @Shadow
        @Final
        private class_2338 comp_589;

        @Inject(method={"update"}, at={@At(value="HEAD")})
        private void startBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_589, this.comp_590, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_START);
        }

        @Inject(method={"update"}, at={@At(value="TAIL")})
        private void endBlockUpdate(class_1937 world, CallbackInfoReturnable<Boolean> cir) {
            MicroTimingLoggerManager.onBlockUpdate(world, this.comp_589, this.comp_590, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_END);
        }
    }
}

