/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.skipcompression;

import carpettisaddition.commands.speedtest.skipcompression.PacketDeflaterWithNetworkSide;
import carpettisaddition.network.TISCMProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2817;

public class SpeedTestCompressionSkipper {
    private static final byte[] DOWNLOAD_PACKET_BYTES_PREFIX = (byte[])class_156.method_656(() -> {
        TISCMProtocol.S2C packetId = TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD;
        return SpeedTestCompressionSkipper.makeBytes(SpeedTestCompressionSkipper.getMinecraftPacketId(class_2598.field_11942, packetId.packet(nbt -> {})), packetId.getId());
    });
    private static final byte[] UPLOAD_PACKET_BYTES_PREFIX = (byte[])class_156.method_656(() -> {
        TISCMProtocol.C2S packetId = TISCMProtocol.C2S.SPEED_TEST_UPLOAD_PAYLOAD;
        class_2817 examplePacket = packetId.packet(nbt -> {});
        return SpeedTestCompressionSkipper.makeBytes(SpeedTestCompressionSkipper.getMinecraftPacketId(class_2598.field_11941, examplePacket), packetId.getId());
    });

    private static byte[] makeBytes(int mcPacketId, String tiscmPacketId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(mcPacketId);
        buf.method_10812(TISCMProtocol.CHANNEL);
        buf.method_10814(tiscmPacketId);
        byte[] result = new byte[buf.readableBytes()];
        buf.readBytes(result);
        buf.release();
        return result;
    }

    private static int getMinecraftPacketId(class_2598 side, class_2596<?> packet) {
        try {
            return Objects.requireNonNull(class_2539.field_20591.method_10781(side, packet));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get " + String.valueOf(side) + " packet id of " + String.valueOf(packet));
        }
    }

    public static boolean isSpeedTestPayloadPacket(PacketDeflaterWithNetworkSide deflater, ByteBuf byteBuf) {
        byte[] prefix;
        class_2598 side = deflater.getNetworkSide$TISCM();
        if (side == null) {
            return false;
        }
        switch (side) {
            case field_11941: {
                prefix = DOWNLOAD_PACKET_BYTES_PREFIX;
                break;
            }
            case field_11942: {
                prefix = UPLOAD_PACKET_BYTES_PREFIX;
                break;
            }
            default: {
                return false;
            }
        }
        byteBuf = byteBuf.slice();
        int n = byteBuf.readableBytes();
        if (n >= prefix.length && n >= 16184) {
            byte[] sample = new byte[prefix.length];
            byteBuf.readBytes(sample);
            return Arrays.equals(sample, prefix);
        }
        return false;
    }
}

