/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.AbstractSetblockStateEvent;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BlockStateChangeEvent
extends AbstractSetblockStateEvent {
    private final Map<class_2769<?>, PropertyChange> changes = Maps.newLinkedHashMap();

    public BlockStateChangeEvent(EventType eventType, class_2680 oldBlockState, class_2680 newBlockState, Boolean returnValue, int flags) {
        super(eventType, "block_state_change", oldBlockState, newBlockState, returnValue, flags);
    }

    public void setChanges(Collection<PropertyChange> changes) {
        this.changes.clear();
        changes.forEach(change -> this.changes.put(change.property, (PropertyChange)change));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private class_5250 getChangesText(boolean isHover) {
        Function<@Nullable class_2769, class_5250> hoverMaker = currentProperty -> {
            ArrayList lines = Lists.newArrayList();
            lines.add(Messenger.formatting(this.tr("state_change_details", new Object[0]), class_124.field_1067));
            this.oldBlockState.method_28501().stream().map(property -> {
                class_5250 text = Optional.ofNullable(this.changes.get(property)).map(PropertyTexts::change).orElseGet(() -> {
                    @Nullable Comparable value = this.oldBlockState.method_11654(property);
                    return PropertyTexts.value(": ", property, value);
                });
                if (property.equals(currentProperty)) {
                    text.method_10852((class_2561)Messenger.s((Object)"    <---", class_124.field_1080));
                }
                return text;
            }).forEach(lines::add);
            return Messenger.join(Messenger.s("\n"), lines.toArray(new class_5250[0]));
        };
        if (isHover) {
            return hoverMaker.apply(null);
        }
        return Messenger.join(Messenger.s(" "), (class_5250[])this.changes.values().stream().map(change -> Messenger.hover(PropertyTexts.value("=", change.property, change.newValue), (class_5250)hoverMaker.apply(change.property))).toArray(class_5250[]::new));
    }

    @Override
    public class_5250 toText() {
        ArrayList list = Lists.newArrayList();
        class_5250 titleText = Messenger.fancy(null, Messenger.formatting(this.tr("state_change", new Object[0]), "c"), this.getFlagsText(), null);
        if (this.getEventType() != EventType.ACTION_END) {
            list.add(Messenger.c(titleText, "g : ", this.getChangesText(false)));
        } else {
            list.add(Messenger.fancy(Messenger.c(titleText, Messenger.getSpaceText(), Messenger.formatting(this.tr("finished", new Object[0]), "q")), this.getChangesText(true), null));
        }
        if (this.returnValue != null) {
            list.add("w  ");
            list.add(MicroTimingUtil.getSuccessText(this.returnValue, true));
        }
        return Messenger.c(list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockStateChangeEvent that = (BlockStateChangeEvent)o;
        return Objects.equals(this.changes, that.changes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }

    public static class PropertyChange {
        public final class_2769<?> property;
        public final Object oldValue;
        public final Object newValue;

        public PropertyChange(class_2769<?> property, Object oldValue, Object newValue) {
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyChange)) {
                return false;
            }
            PropertyChange changes = (PropertyChange)o;
            return Objects.equals(this.property, changes.property) && Objects.equals(this.oldValue, changes.oldValue) && Objects.equals(this.newValue, changes.newValue);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.oldValue, this.newValue);
        }
    }

    public static class PropertyTexts {
        public static class_5250 value(String divider, class_2769<?> property, Object value) {
            return Messenger.c(Messenger.s(property.method_11899()), "g " + divider, Messenger.property(property, value));
        }

        public static class_5250 change(class_2769<?> property, Object oldValue, Object newValue) {
            return Messenger.c(Messenger.s(property.method_11899()), "g : ", Messenger.property(property, oldValue), "g ->", Messenger.property(property, newValue));
        }

        public static class_5250 change(PropertyChange propertyChange) {
            return PropertyTexts.change(propertyChange.property, propertyChange.oldValue, propertyChange.newValue);
        }
    }
}

