/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.settings.validator;

import carpettisaddition.settings.validator.AbstractCheckerValidator;
import carpettisaddition.settings.validator.ValidationContext;
import net.minecraft.class_5250;

public abstract class RangedNumberValidator<T extends Number>
extends AbstractCheckerValidator<T> {
    protected final T lowerBound;
    protected final T upperBound;

    public RangedNumberValidator(T lowerBound, T upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    protected boolean validateValue(T value) {
        return ((Number)this.lowerBound).doubleValue() <= ((Number)value).doubleValue() && ((Number)value).doubleValue() <= ((Number)this.upperBound).doubleValue();
    }

    @Override
    public class_5250 errorMessage(ValidationContext<T> ctx) {
        return RangedNumberValidator.tr("ranged_number.message", this.lowerBound, this.upperBound);
    }
}

