/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.deobfuscator;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.AutoMixinAuditExecutor;
import carpettisaddition.utils.deobfuscator.mapping.TinyMappingV2Reader;
import carpettisaddition.utils.deobfuscator.yarn.OnlineMappingProvider;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class StackTraceDeobfuscator {
    static Map<String, String> MAPPING = Maps.newHashMap();
    static boolean fetchedMapping = false;
    static String MAPPING_VERSION = "no mapping";
    static final Translator translator = new Translator("util.stack_trace");

    public static synchronized void fetchMapping() {
        if (AutoMixinAuditExecutor.isEnabled()) {
            CarpetTISAdditionServer.LOGGER.info("Disabled online mapping fetching since mixin audit executor is armed");
            return;
        }
        if (!fetchedMapping) {
            OnlineMappingProvider.getMapping();
            fetchedMapping = true;
        }
    }

    public static boolean loadMappings(InputStream inputStream, String mappingVersion) {
        Map<String, String> mappings;
        TinyMappingV2Reader mappingReader = new TinyMappingV2Reader();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            mappings = mappingReader.readMapping(reader);
        }
        catch (Exception e) {
            CarpetTISAdditionServer.LOGGER.error("Fail to load mapping {}", (Object)mappingVersion, (Object)e);
            return false;
        }
        MAPPING = mappings;
        MAPPING_VERSION = mappingVersion;
        return true;
    }

    public static StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] stackTraceElements, @Nullable String ignoreClassPath) {
        ArrayList list = Lists.newArrayList();
        for (StackTraceElement element : stackTraceElements) {
            String remappedClass = MAPPING.get(element.getClassName());
            String remappedMethod = MAPPING.get(element.getMethodName());
            StackTraceElement newElement = new StackTraceElement(remappedClass != null ? remappedClass : element.getClassName(), remappedMethod != null ? remappedMethod : element.getMethodName(), remappedClass != null ? StackTraceDeobfuscator.getFileName(remappedClass) : element.getFileName(), element.getLineNumber());
            list.add(newElement);
            if (ignoreClassPath == null || !newElement.getClassName().startsWith(ignoreClassPath)) continue;
            list.clear();
        }
        return list.toArray(new StackTraceElement[0]);
    }

    public static StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] stackTraceElements) {
        return StackTraceDeobfuscator.deobfuscateStackTrace(stackTraceElements, null);
    }

    private static String getFileName(String className) {
        if (className.isEmpty()) {
            return className;
        }
        return className.substring(className.lastIndexOf(46) + 1).split("\\$", 2)[0] + ".java";
    }
}

