/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.tester;

import carpettisaddition.commands.speedtest.SpeedTestPacketUtils;
import carpettisaddition.commands.speedtest.SpeedTestReporter;
import carpettisaddition.commands.speedtest.ping.PingHandler;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSession;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSessionHolder;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessenger;
import carpettisaddition.commands.speedtest.tester.SpeedTesterPayloadSenderBase;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import net.minecraft.class_3222;

public class SpeedTestDownloader
extends SpeedTesterPayloadSenderBase
implements SpeedTestServerSession {
    private final class_3222 player;
    private final SpeedTestServerSessionHolder serverSessionHolder;
    private final SpeedTestReporter reporter;

    public SpeedTestDownloader(class_3222 player, int totalSizeMb, SpeedTestServerSessionHolder serverSessionHolder, SpeedTestReporter reporter) {
        super(totalSizeMb);
        this.player = player;
        this.serverSessionHolder = serverSessionHolder;
        this.reporter = reporter;
    }

    @Override
    public SpeedTestSessionMessenger getMessenger() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter.start(this.totalSize);
        super.start();
        this.serverSessionHolder.setFor(this.player, this);
    }

    @Override
    protected void sendOnePacket() {
        TISCMServerPacketHandler.getInstance().sendPacket(this.player.field_13987, TISCMProtocol.S2C.SPEED_TEST_DOWNLOAD_PAYLOAD, nbt -> nbt.method_10570("buf", SpeedTestPacketUtils.getPayloadByteArray()), this::onPayloadDone);
    }

    @Override
    protected void sendPingPacket(PingHandler pingHandler, PingHandler.PongCallback pongCallback) {
        pingHandler.pingClient(this.player.field_13987, pongCallback);
    }

    @Override
    protected void onProgress(long sentBytes, long totalBytes) {
        this.reporter.onProgress(this.timer.getTimeElapsedNs(), sentBytes, totalBytes);
    }

    @Override
    protected void onDone(long timeCostNs) {
        this.reporter.reportDone(timeCostNs, this.processedSize.get(), this.totalSize);
        this.serverSessionHolder.clearFor(this.player, this);
    }
}

