/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.updateSuppressionSimulator;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class UpdateSuppressionSimulator {
    private static final String ERROR_MESSAGE = "TISCM UpdateSuppressionSimulator";
    private static final Map<String, Runnable> SUPPORTED_ERRORS = ImmutableMap.of((Object)"StackOverflowError", () -> {
        throw new StackOverflowError(ERROR_MESSAGE);
    }, (Object)"OutOfMemoryError", () -> {
        throw new OutOfMemoryError(ERROR_MESSAGE);
    }, (Object)"ClassCastException", () -> {
        throw new ClassCastException(ERROR_MESSAGE);
    }, (Object)"IllegalArgumentException", () -> {
        throw new IllegalArgumentException(ERROR_MESSAGE);
    });
    private static final Runnable DUMMY;
    private static Runnable nuke;

    public static boolean isActivated() {
        return nuke != DUMMY;
    }

    public static void kaboom() {
        nuke.run();
    }

    private static Optional<Runnable> parseRule(String ruleValue) {
        switch (ruleValue) {
            case "true": {
                return Optional.of(SUPPORTED_ERRORS.values().iterator().next());
            }
            case "false": {
                return Optional.of(DUMMY);
            }
        }
        Runnable[] ret = new Runnable[]{null};
        SUPPORTED_ERRORS.forEach((key, value) -> {
            if (key.equalsIgnoreCase(ruleValue)) {
                ret[0] = value;
            }
        });
        return Optional.ofNullable(ret[0]);
    }

    public static void acceptRule(String ruleValue) {
        nuke = UpdateSuppressionSimulator.parseRule(ruleValue).orElseThrow(RuntimeException::new);
    }

    public static boolean checkRule(String ruleValue) {
        return UpdateSuppressionSimulator.parseRule(ruleValue).isPresent();
    }

    static {
        nuke = DUMMY = () -> {};
    }
}

