/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class ReflectionUtils {
    public static Optional<Object> getField(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return Optional.ofNullable(field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static BiFunction<Object, Object[], Object> invoker(Method method) {
        method.setAccessible(true);
        return (obj, args) -> {
            try {
                return method.invoke(obj, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new InvocationException(e);
            }
        };
    }

    public static Optional<BiFunction<Object, Object[], Object>> invoker(Class<?> clazz, String methodName, Predicate<Method> methodPredicate) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !methodPredicate.test(method)) continue;
            return Optional.of(ReflectionUtils.invoker(method));
        }
        return Optional.empty();
    }

    public static Optional<BiFunction<Object, Object[], Object>> invoker(String className, String methodName, Predicate<Method> methodPredicate) {
        return ReflectionUtils.getClass(className).flatMap(clazz -> ReflectionUtils.invoker(clazz, methodName, methodPredicate));
    }

    public static Optional<BiFunction<Object, Object[], Object>> invoker(String className, String methodName) {
        return ReflectionUtils.invoker(className, methodName, (Method m) -> true);
    }

    public static Optional<Function<Object[], Object>> constructor(String className, Class<?> ... parameterTypes) {
        return ReflectionUtils.getClass(className).map(clazz -> {
            Constructor constructor;
            try {
                constructor = clazz.getDeclaredConstructor(parameterTypes);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            return args -> {
                try {
                    return constructor.newInstance(args);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    return new InvocationException(e);
                }
            };
        });
    }

    public static class InvocationException
    extends RuntimeException {
        public InvocationException(Throwable cause) {
            super(cause);
        }
    }
}

