/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition;

import carpet.utils.CommandHelper;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.commands.xcounter.HopperXpCountersRuleListener;
import carpettisaddition.helpers.rule.fakePlayerNameExtra.FakePlayerNameExtraValidator;
import carpettisaddition.helpers.rule.instantBlockUpdaterReintroduced.InstantBlockUpdaterReintroducedRuleListener;
import carpettisaddition.helpers.rule.synchronizedLightThread.LightThreadSynchronizer;
import carpettisaddition.helpers.rule.updateSuppressionSimulator.UpdateSuppressionSimulator;
import carpettisaddition.helpers.rule.voidDamageIgnorePlayer.VoidDamageIgnorePlayerValidator;
import carpettisaddition.logging.loggers.microtiming.enums.MicroTimingTarget;
import carpettisaddition.logging.loggers.microtiming.enums.TickDivision;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingDyeMarkerRuleValidator;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingRuleListener;
import carpettisaddition.settings.Rule;
import carpettisaddition.settings.validator.AbstractCheckerValidator;
import carpettisaddition.settings.validator.AbstractValidator;
import carpettisaddition.settings.validator.OptionalPercentValidator;
import carpettisaddition.settings.validator.OptionalProbablyValidator;
import carpettisaddition.settings.validator.PermissionLevelValidator;
import carpettisaddition.settings.validator.RangedNumberValidator;
import carpettisaddition.settings.validator.RuleChangeListener;
import carpettisaddition.settings.validator.ValidationContext;
import carpettisaddition.settings.validator.Validators;
import carpettisaddition.utils.MixinUtils;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CarpetTISAdditionSettings {
    public static boolean isLoadingRulesFromConfig = false;
    public static final String TIS = "TIS";
    public static final String TISCM_PROTOCOL = "TISCM_protocol";
    public static final String LOGGER = "logger";
    public static final String CARPET_MOD = "carpet_mod";
    public static final String PORTING = "porting";
    @Rule(categories={"TIS", "creative", "survival"})
    public static boolean antiSpamDisabled = false;
    public static final double VANILLA_BLOCK_EVENT_PACKET_RANGE = 64.0;
    @Rule(validators={Validators.NonNegativeNumber.class}, options={"0", "16", "64", "128"}, strict=false, categories={"TIS", "optimization"})
    public static double blockEventPacketRange = 64.0;
    @Rule(categories={"TIS", "creative"})
    public static boolean blockPlacementIgnoreEntity = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean breedingCooldownDisabled = false;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean cauldronBlockItemInteractFix = false;
    @Rule(categories={"TIS", "client"})
    public static boolean chatMessageLengthLimitUnlocked = false;
    public static final int VANILLA_CHUNK_UPDATE_PACKET_THRESHOLD = 64;
    public static final int MAXIMUM_CHUNK_UPDATE_PACKET_THRESHOLD = 65536;
    @Rule(validators={ValidateChunkUpdatePacketThreshold.class}, options={"64", "4096", "65536"}, strict=false, categories={"TIS", "optimization", "experimental"})
    public static int chunkUpdatePacketThreshold = 64;
    @Rule(options={"0", "1", "10", "100", "1000"}, validators={Validators.NonNegativeNumber.class}, strict=false, categories={"TIS", "creative"})
    public static int chunkTickSpeed = 1;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean clientSettingsLostOnRespawnFix = false;
    @Rule(categories={"TIS", "command"})
    public static String commandLifeTime = "true";
    @Rule(categories={"TIS", "command", "experimental"})
    public static String commandManipulate = "false";
    @Rule(categories={"TIS", "command", "creative"})
    public static String commandPlayerActionPerTick = "false";
    @Rule(categories={"TIS", "command"})
    public static String commandRaid = "true";
    @Rule(categories={"TIS", "command"})
    public static String commandRaycast = "ops";
    @Rule(categories={"TIS", "command"})
    public static String commandRefresh = "true";
    @Rule(categories={"TIS", "command", "creative"})
    public static String commandRemoveEntity = "ops";
    @Rule(categories={"TIS", "command", "creative"})
    public static String commandSleep = "ops";
    @Rule(categories={"TIS", "command", "TISCM_protocol"})
    public static String commandSpeedTest = "false";
    @Rule(categories={"TIS", "creative"})
    public static boolean creativeInstantTame = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean creativeNetherWaterPlacement = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean creativeNoItemCooldown = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean creativeOpenContainerForcibly = false;
    @Rule(categories={"TIS", "client"})
    public static boolean debugNbtQueryNoPermission = false;
    @Rule(categories={"TIS", "feature"})
    public static boolean deobfuscateCrashReportStackTrace = false;
    @Rule(categories={"TIS", "dispenser", "creative"})
    public static boolean dispenserNoItemCost = false;
    @Rule(categories={"TIS", "feature", "dispenser"})
    public static boolean dispensersFireDragonBreath = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean dustTrapdoorReintroduced = false;
    @Rule(categories={"TIS", "porting"})
    public static boolean elytraFireworkKeepLeashConnection = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean enchantCommandNoRestriction = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean endPortalOpenedSoundDisabled = false;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean entityBrainMemoryUnfreedFix = false;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean entityChunkSectionIndexXOverflowFix = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean entityInstantDeathRemoval = false;
    @Rule(categories={"TIS", "experimental"})
    public static boolean entityMomentumLoss = true;
    @Rule(categories={"TIS", "creative"})
    public static boolean entityPlacementIgnoreCollision = false;
    @Rule(options={"-1", "16", "64"}, strict=false, categories={"TIS", "creative"})
    public static int entityTrackerDistance = -1;
    @Rule(options={"-1", "1"}, strict=false, categories={"TIS", "creative"})
    public static int entityTrackerInterval = -1;
    @Rule(categories={"TIS", "creative"})
    public static boolean explosionNoEntityInfluence = false;
    public static final double VANILLA_EXPLOSION_PACKET_RANGE = 64.0;
    @Rule(validators={Validators.NonNegativeNumber.class}, options={"0", "16", "64", "128", "2048"}, strict=false, categories={"TIS", "creative"})
    public static double explosionPacketRange = 64.0;
    @Rule(categories={"TIS", "creative"})
    public static boolean failSoftBlockStateParsing = false;
    public static final String fakePlayerNameNoExtra = "#none";
    @Rule(options={"#none", "bot_"}, validators={FakePlayerNameExtraValidator.class}, strict=false, categories={"TIS", "carpet_mod"})
    public static String fakePlayerNamePrefix = "#none";
    @Rule(options={"#none", "_fake"}, validators={FakePlayerNameExtraValidator.class}, strict=false, categories={"TIS", "carpet_mod"})
    public static String fakePlayerNameSuffix = "#none";
    @Rule(categories={"TIS", "carpet_mod"})
    public static boolean fakePlayerTicksLikeRealPlayer = false;
    @Rule(categories={"TIS", "carpet_mod"}, validators={PermissionLevelValidator.class})
    public static String fakePlayerRemoteSpawning = "true";
    @Rule(categories={"TIS", "creative"})
    public static boolean farmlandTrampledDisabled = false;
    @Rule(categories={"TIS", "creative", "command"})
    public static String fillCommandModeEnhance = "true";
    @Rule(categories={"TIS", "creative"})
    public static boolean flattenTriangularDistribution = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean fluidDestructionDisabled = false;
    @Rule(categories={"TIS", "creative", "carpet_mod"})
    public static boolean hopperCountersUnlimitedSpeed = false;
    @Rule(categories={"TIS", "creative", "command"})
    public static boolean hopperNoItemCost = false;
    @Rule(categories={"TIS", "creative", "command"}, validators={HopperXpCountersRuleListener.class})
    public static boolean hopperXpCounters = false;
    @Rule(options={"1", "5", "20", "100"}, validators={ValidateHUDLoggerUpdateInterval.class}, strict=false, categories={"TIS", "carpet_mod"})
    public static int HUDLoggerUpdateInterval = 20;
    @Rule(categories={"TIS", "creative", "porting"}, validators={InstantBlockUpdaterReintroducedRuleListener.class})
    public static boolean instantBlockUpdaterReintroduced = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean instantCommandBlock = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean itemEntitySkipMovementDisabled = false;
    @Rule(categories={"TIS", "feature", "experimental"})
    public static boolean keepMobInLazyChunks = false;
    @Rule(categories={"TIS", "feature", "experimental"})
    public static boolean largeBarrel = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean lifeTimeTrackerConsidersMobcap = true;
    @Rule(validators={Validators.PositiveNumber.class}, options={"1", "20", "60", "100", "6000"}, strict=false, categories={"TIS"})
    public static int lightQueueLoggerSamplingDuration = 60;
    @Rule(categories={"TIS", "creative", "experimental"}, validators={ValidateLightUpdates.class})
    public static LightUpdateOptions lightUpdates = LightUpdateOptions.ON;
    @Rule(categories={"TIS", "logger"})
    public static String loggerMovement = "ops";
    @Rule(categories={"TIS", "command", "experimental"}, validators={Validators.PositiveNumber.class}, options={"1000", "1000000", "1000000000"}, strict=false)
    public static int manipulateBlockLimit = 1000000;
    @Rule(categories={"TIS", "creative"}, validators={MicroTimingRuleListener.class})
    public static boolean microTiming = false;
    @Rule(options={"false", "true", "clear"}, validators={MicroTimingDyeMarkerRuleValidator.class}, categories={"TIS", "creative"})
    public static String microTimingDyeMarker = "true";
    @Rule(categories={"TIS", "creative"}, validators={ValidateMicroTimingTarget.class})
    public static MicroTimingTarget microTimingTarget = MicroTimingTarget.MARKER_ONLY;
    @Rule(categories={"TIS", "creative"})
    public static TickDivision microTimingTickDivision = TickDivision.WORLD_TIMER;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean minecartFullDropBackport = false;
    @Rule(categories={"TIS", "creative", "feature"})
    public static boolean minecartPlaceableOnGround = false;
    public static final double VANILLA_MINECART_TAKE_PASSENGER_MIN_VELOCITY = 0.1;
    @Rule(options={"0", "0.1", "NaN"}, strict=false, categories={"TIS", "creative"})
    public static double minecartTakePassengerMinVelocity = 0.1;
    @Rule(categories={"TIS", "carpet_mod"})
    public static boolean mobcapsDisplayIgnoreMisc = false;
    @Rule(categories={"TIS", "feature"})
    public static boolean moveableReinforcedDeepslate = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean naturalSpawningUse13Heightmap = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean naturalSpawningUse13HeightmapExtra = false;
    public static final int VANILLA_NETHER_PORTAL_MAX_SIZE = 21;
    @Rule(categories={"TIS", "creative"}, validators={ValidateNetherPortalMaxSize.class}, options={"21", "64", "128", "384"}, strict=false)
    public static int netherPortalMaxSize = 21;
    @Rule(categories={"TIS", "creative"}, validators={OptionalPercentValidator.class}, options={"-1", "0", "50", "100"}, strict=false)
    public static int oakBalloonPercent = -1;
    @Rule(categories={"TIS", "creative"})
    public static boolean observerNoDetection = false;
    @Rule(categories={"TIS", "survival", "command"})
    public static boolean opPlayerNoCheat = false;
    @Rule(categories={"TIS", "optimization", "experimental"})
    public static boolean optimizedFastEntityMovement = false;
    @Rule(categories={"TIS", "optimization", "experimental"}, restrictions={@Restriction(conflict={@Condition(value="async")})})
    public static boolean optimizedHardHitBoxEntityCollision = false;
    @Rule(categories={"TIS", "optimization", "experimental"})
    public static boolean optimizedTNTHighPriority = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean overspawningReintroduced = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean poiUpdates = true;
    @Rule(categories={"TIS", "carpet_mod"})
    public static boolean persistentLoggerSubscription = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean preciseEntityPlacement = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean redstoneDustRandomUpdateOrder = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean redstoneDustRepeaterComparatorIgnoreUpwardsStateUpdate = false;
    @Rule(categories={"TIS", "feature"})
    public static boolean renewableDragonEgg = false;
    @Rule(categories={"TIS", "feature"})
    public static boolean renewableDragonHead = false;
    @Rule(options={"0", "0.2", "1"}, validators={Validators.Probability.class}, strict=false, categories={"TIS", "feature"})
    public static double renewableElytra = 0.0;
    @Rule(categories={"TIS", "creative"})
    public static boolean repeaterHalfDelay = false;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean sandDupingFix = false;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean shulkerBoxCCEReintroduced = false;
    public static final int VANILLA_SNOW_MELT_MIN_LIGHT_LEVEL = 12;
    @Rule(options={"0", "10", "12"}, strict=false, validators={Validators.NonNegativeNumber.class}, categories={"TIS", "creative"})
    public static int snowMeltMinLightLevel = 12;
    @Rule(categories={"TIS", "creative"}, validators={OptionalProbablyValidator.class}, options={"-1", "0", "0.5", "1"}, strict=false)
    public static double spawnBabyProbably = -1.0;
    @Rule(categories={"TIS", "creative"}, validators={OptionalProbablyValidator.class}, options={"-1", "0", "0.5", "1"}, strict=false)
    public static double spawnJockeyProbably = -1.0;
    @Rule(options={"10", "100", "1024", "10240"}, strict=false, validators={Validators.PositiveNumber.class}, categories={"TIS", "command"})
    public static int speedTestCommandMaxTestSize = 10;
    @Rule(categories={"TIS", "command"})
    public static boolean stopCommandDoubleConfirmation = false;
    @Rule(categories={"TIS", "creative", "bugfix"})
    public static boolean structureBlockDoNotPreserveFluid = false;
    @Rule(categories={"TIS", "creative", "experimental"}, validators={ValidateSynchronizedLightThread.class})
    public static boolean synchronizedLightThread = false;
    @Rule(categories={"TIS", "TISCM_protocol"})
    public static boolean syncServerMsptMetricsData = false;
    @Rule(categories={"TIS", "carpet_mod", "command", "porting"})
    public static boolean tickCommandCarpetfied = false;
    @Rule(categories={"TIS", "carpet_mod", "command"})
    public static boolean tickCommandEnhance = false;
    public static final String VANILLA_TICK_COMMAND_PERMISSION = "3";
    @Rule(categories={"TIS", "carpet_mod", "command"})
    public static String tickCommandPermission = "3";
    @Rule(categories={"TIS", "carpet_mod", "command", "porting"})
    public static boolean tickFreezeCommandToggleable = false;
    @Rule(categories={"TIS", "carpet_mod", "command", "porting"})
    public static boolean tickProfilerCommandsReintroduced = false;
    @Rule(categories={"TIS", "carpet_mod", "command", "porting"})
    public static boolean tickWarpCommandAsAnAlias = false;
    @Rule(options={"1024", "65536", "2147483647"}, validators={Validators.PositiveNumber.class}, strict=false, categories={"TIS", "creative"})
    public static int tileTickLimit = 65536;
    @Rule(categories={"TIS", "TISCM_protocol"})
    public static boolean tiscmNetworkProtocol = false;
    @Rule(categories={"TIS", "bugfix", "experimental"})
    public static boolean tntDupingFix = false;
    public static final int VANILLA_TNT_FUSE_DURATION = 80;
    @Rule(options={"0", "80", "32767"}, validators={ValidateTNTFuseDuration.class}, strict=false, categories={"TIS", "creative"})
    public static int tntFuseDuration = 80;
    @Rule(categories={"TIS", "creative"})
    public static boolean tntIgnoreRedstoneSignal = false;
    @Rule(categories={"TIS", "feature"})
    public static boolean tooledTNT = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean totallyNoBlockUpdate = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean toughWitherRose = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean turtleEggTrampledDisabled = false;
    @Rule(options={"false"}, validators={ValidateUltraSecretSetting.class}, strict=false, categories={"TIS", "experimental"})
    public static String ultraSecretSetting = "false";
    @Rule(categories={"TIS", "creative"})
    public static boolean undeadDontBurnInSunlight = false;
    @Rule(categories={"TIS", "creative"})
    public static boolean updateSkippingSimulator = false;
    @Rule(categories={"TIS", "creative"}, validators={UpdateSuppressionSimulatorValidator.class}, options={"false", "true", "StackOverflowError", "OutOfMemoryError", "ClassCastException", "IllegalArgumentException"})
    public static String updateSuppressionSimulator = "false";
    @Rule(categories={"TIS", "creative"})
    public static boolean vaultBlacklistDisabled = false;
    @Rule(categories={"TIS", "creative"})
    public static ViolentNetherPortalCreationOptions violentNetherPortalCreation = ViolentNetherPortalCreationOptions.FALSE;
    @Rule(categories={"TIS", "creative"})
    public static boolean visualizeProjectileLoggerEnabled = false;
    public static final double VANILLA_VOID_DAMAGE_AMOUNT = 4.0;
    @Rule(options={"0", "4", "1000"}, validators={Validators.NonNegativeNumber.class}, strict=false, categories={"TIS", "creative"})
    public static double voidDamageAmount = 4.0;
    @Rule(options={"false", "true", "creative", "spectator", "creative,spectator"}, validators={VoidDamageIgnorePlayerValidator.class}, strict=false, categories={"TIS", "creative"})
    public static String voidDamageIgnorePlayer = "false";
    @Rule(options={"-64", "-512", "-4096"}, validators={Validators.NegativeNumber.class}, strict=false, categories={"TIS", "creative"})
    public static double voidRelatedAltitude = -64.0;
    @Rule(categories={"TIS", "feature", "porting"})
    public static boolean wetExplosionReintroduced;
    @Rule(categories={"TIS", "creative"})
    public static boolean witherSpawnedSoundDisabled;
    @Rule(options={"0", "1", "8", "32"}, validators={ValidateXPTrackingDistance.class}, strict=false, categories={"TIS", "creative"})
    public static double xpTrackingDistance;
    @Rule(categories={"TIS"})
    public static boolean yeetAsyncTaskExecutionDelay;
    @Rule(categories={"TIS"})
    public static boolean yeetIdleMspt;
    @Rule(categories={"TIS"})
    public static boolean yeetOutOfOrderChatKick;
    @Rule(categories={"TIS", "bugfix"})
    public static boolean yeetUpdateSuppressionCrash;

    public static void onWorldLoadingStarted() {
        if (!lightUpdates.shouldExecuteLightTask()) {
            CarpetTISAdditionMod.LOGGER.warn("The rule lightUpdates is set to {} before the worlds are loaded", (Object)lightUpdates);
            CarpetTISAdditionMod.LOGGER.warn("This might cause the server to be blocked indefinitely");
        }
    }

    static {
        witherSpawnedSoundDisabled = false;
        xpTrackingDistance = 8.0;
        yeetAsyncTaskExecutionDelay = false;
        yeetIdleMspt = false;
        yeetOutOfOrderChatKick = false;
        yeetUpdateSuppressionCrash = false;
    }

    public static enum LightUpdateOptions {
        ON(true, true),
        SUPPRESSED(true, false),
        IGNORED(false, true),
        OFF(false, false);

        private final boolean shouldEnqueue;
        private final boolean shouldExecute;

        private LightUpdateOptions(boolean shouldEnqueue, boolean shouldExecute) {
            this.shouldEnqueue = shouldEnqueue;
            this.shouldExecute = shouldExecute;
        }

        public boolean shouldEnqueueLightTask() {
            return this.shouldEnqueue;
        }

        public boolean shouldExecuteLightTask() {
            return this.shouldExecute;
        }
    }

    public static enum ViolentNetherPortalCreationOptions {
        FALSE,
        REPLACEABLE,
        ALL;

    }

    private static class ValidateXPTrackingDistance
    extends RangedNumberValidator<Double> {
        public ValidateXPTrackingDistance() {
            super(0.0, 128.0);
        }
    }

    private static class UpdateSuppressionSimulatorValidator
    extends AbstractCheckerValidator<String> {
        private UpdateSuppressionSimulatorValidator() {
        }

        @Override
        protected boolean validateValue(String value) {
            return UpdateSuppressionSimulator.checkRule(value);
        }

        @Override
        public void onRuleSet(ValidationContext<String> ctx, String newValue) {
            UpdateSuppressionSimulator.acceptRule(newValue);
        }
    }

    private static class ValidateUltraSecretSetting
    extends AbstractValidator<String> {
        private ValidateUltraSecretSetting() {
        }

        @Override
        @Nullable
        protected String validate(ValidationContext<String> ctx) {
            if (((String)ctx.inputValue).equals("mixin_audit")) {
                MixinUtils.audit(ctx.source);
                return (String)ctx.rule.value();
            }
            if (ctx.source != null) {
                CommandHelper.notifyPlayersCommandsChanged((MinecraftServer)CarpetTISAdditionServer.minecraft_server);
            }
            return (String)ctx.inputValue;
        }
    }

    private static class ValidateTNTFuseDuration
    extends RangedNumberValidator<Integer> {
        public ValidateTNTFuseDuration() {
            super(0, Short.MAX_VALUE);
        }
    }

    private static class ValidateSynchronizedLightThread
    extends AbstractCheckerValidator<Boolean> {
        private ValidateSynchronizedLightThread() {
        }

        @Override
        protected boolean validateContext(ValidationContext<Boolean> ctx) {
            return LightThreadSynchronizer.checkRuleSafety(ctx.source, (Boolean)ctx.inputValue, lightUpdates);
        }
    }

    private static class ValidateNetherPortalMaxSize
    extends RangedNumberValidator<Integer> {
        public ValidateNetherPortalMaxSize() {
            super(2, 384);
        }
    }

    public static class ValidateMicroTimingTarget
    extends RuleChangeListener<MicroTimingTarget> {
        @Override
        public void onRuleSet(ValidationContext<MicroTimingTarget> ctx, @NotNull MicroTimingTarget newValue) {
            if (newValue != MicroTimingTarget.MARKER_ONLY) {
                ctx.optionalSource().ifPresent(MicroTimingTarget::deprecatedWarning);
            }
        }
    }

    private static class ValidateLightUpdates
    extends AbstractCheckerValidator<LightUpdateOptions> {
        private ValidateLightUpdates() {
        }

        @Override
        protected boolean validateContext(ValidationContext<LightUpdateOptions> ctx) {
            return LightThreadSynchronizer.checkRuleSafety(ctx.source, synchronizedLightThread, (LightUpdateOptions)((Object)ctx.inputValue));
        }
    }

    private static class ValidateHUDLoggerUpdateInterval
    extends RangedNumberValidator<Integer> {
        public ValidateHUDLoggerUpdateInterval() {
            super(1, 1000);
        }
    }

    private static class ValidateChunkUpdatePacketThreshold
    extends RangedNumberValidator<Integer> {
        public ValidateChunkUpdatePacketThreshold() {
            super(2, 65536);
        }
    }
}

