/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.translations.Translator;
import com.google.common.base.Joiner;
import com.mojang.brigadier.StringReader;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2554;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLogger
extends TranslationContext {
    private static final Translator TRANSLATOR = new Translator("logger");
    public static final String MULTI_OPTION_SEP_REG = "[,. ]";
    public static final String OPTION_SEP = ",";
    private final String name;
    private final boolean strictOption;

    public AbstractLogger(String name, boolean strictOption) {
        super(TRANSLATOR.getDerivedTranslator(name));
        this.name = name;
        this.strictOption = strictOption;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDefaultLoggingOption() {
        String[] suggested = this.getSuggestedLoggingOption();
        return suggested != null && suggested.length > 0 ? suggested[0] : null;
    }

    @Nullable
    public String[] getSuggestedLoggingOption() {
        return null;
    }

    public Logger createCarpetLogger() {
        return TISAdditionLoggerRegistry.standardLogger(this.getName(), AbstractLogger.wrapOption(this.getDefaultLoggingOption()), AbstractLogger.wrapOptions(this.getSuggestedLoggingOption()), this.strictOption);
    }

    protected void actionWithLogger(Consumer<Logger> action) {
        Logger logger = LoggerRegistry.getLogger((String)this.getName());
        if (logger != null) {
            action.accept(logger);
        } else {
            CarpetTISAdditionServer.LOGGER.warn("Failed to get carpet logger {}", (Object)this.getName());
        }
    }

    public void log(Supplier<class_2554[]> messagePromise) {
        this.actionWithLogger(logger -> logger.log(messagePromise));
    }

    public void log(Logger.lMessage messagePromise) {
        this.actionWithLogger(logger -> logger.log(messagePromise));
    }

    public void log(Logger.lMessageIgnorePlayer messagePromise) {
        this.actionWithLogger(logger -> logger.log(messagePromise));
    }

    protected static String wrapOption(@Nullable String option) {
        if (option == null) {
            return null;
        }
        boolean requiresQuotes = false;
        for (int i = 0; i < ((String)option).length(); ++i) {
            if (StringReader.isAllowedInUnquotedString((char)((String)option).charAt(i))) continue;
            requiresQuotes = true;
            break;
        }
        if (requiresQuotes) {
            option = "\"" + ((String)option).replace("\"", "\"\"") + "\"";
        }
        return option;
    }

    protected static String[] wrapOptions(String ... options) {
        if (options == null) {
            return null;
        }
        options = (String[])options.clone();
        for (int i = 0; i < options.length; ++i) {
            options[i] = AbstractLogger.wrapOption(options[i]);
        }
        return options;
    }

    protected static String createCompoundOption(Iterable<String> options) {
        return Joiner.on((String)OPTION_SEP).join(options);
    }

    protected static String createCompoundOption(String ... options) {
        return AbstractLogger.createCompoundOption(Arrays.asList(options));
    }
}

