/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.PistonBlockEventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1919;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2554;
import net.minecraft.class_2665;

public class ExecuteBlockEventEvent
extends BaseEvent {
    private final class_1919 blockAction;
    private Boolean returnValue;
    private FailInfo failInfo;

    public ExecuteBlockEventEvent(EventType eventType, class_1919 blockAction, Boolean returnValue, FailInfo failInfo) {
        super(eventType, "execute_block_event", blockAction.method_8309());
        this.blockAction = blockAction;
        this.returnValue = returnValue;
        this.failInfo = failInfo;
        if (this.failInfo != null) {
            this.failInfo.setEvent(this);
        }
    }

    public static class_2554 getMessageExtraMessengerHoverText(class_1919 blockAction) {
        int eventID = blockAction.method_8307();
        int eventParam = blockAction.method_8308();
        ArrayList builder = Lists.newArrayList();
        builder.add(String.format("w eventID: %d", eventID));
        if (blockAction.method_8309() instanceof class_2665) {
            builder.add(Messenger.c(Messenger.s(" ("), PistonBlockEventType.fromId(eventID).toText(), Messenger.s(")")));
        }
        builder.add(Messenger.newLine());
        builder.add(String.format("w eventParam: %d", eventParam));
        if (blockAction.method_8309() instanceof class_2665) {
            builder.add("w  (");
            builder.add(MicroTimingUtil.getFormattedDirectionText(class_2350.method_10143((int)eventParam)));
            builder.add("w )");
        }
        return Messenger.c(builder.toArray(new Object[0]));
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(Messenger.formatting(this.tr("execute", new Object[0]), "c"));
        list.add(Messenger.getSpaceText());
        class_2554 eventName = this.blockAction.method_8309() instanceof class_2665 ? Messenger.formatting(PistonBlockEventType.fromId(this.blockAction.method_8307()).toText(), "c") : Messenger.formatting(this.tr("blockevent", new Object[0]), "c");
        list.add(Messenger.fancy(eventName, ExecuteBlockEventEvent.getMessageExtraMessengerHoverText(this.blockAction), null));
        if (this.getEventType() == EventType.ACTION_END) {
            list.add(Messenger.getSpaceText());
            list.add(Messenger.formatting(this.tr("ended", new Object[0]), "q"));
        }
        if (this.returnValue != null) {
            list.add("w  ");
            list.add(MicroTimingUtil.getSuccessText(this.returnValue, true, this.failInfo != null && this.returnValue == false ? this.failInfo.toText() : null));
        }
        return Messenger.c(list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecuteBlockEventEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecuteBlockEventEvent that = (ExecuteBlockEventEvent)o;
        return Objects.equals(this.blockAction, that.blockAction) && Objects.equals(this.returnValue, that.returnValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockAction, this.returnValue);
    }

    @Override
    public void mergeQuitEvent(BaseEvent quitEvent) {
        super.mergeQuitEvent(quitEvent);
        if (quitEvent instanceof ExecuteBlockEventEvent) {
            this.returnValue = ((ExecuteBlockEventEvent)quitEvent).returnValue;
            this.failInfo = ((ExecuteBlockEventEvent)quitEvent).failInfo;
        }
    }

    public static class FailInfo {
        private final FailReason reason;
        private final class_2248 actualBlock;
        private ExecuteBlockEventEvent event;

        public FailInfo(FailReason reason, class_2248 block) {
            this.reason = reason;
            this.actualBlock = block;
        }

        public void setEvent(ExecuteBlockEventEvent event) {
            this.event = event;
        }

        public class_2554 toText() {
            switch (this.reason.ordinal()) {
                case 0: {
                    return Messenger.c(this.event.tr("fail_info.block_changed", new Object[0]), "w : ", Messenger.block(this.event.blockAction.method_8309()), "g  -> ", Messenger.block(this.actualBlock));
                }
            }
            return this.event.tr("fail_info.event_fail", new Object[0]);
        }
    }

    public static enum FailReason {
        BLOCK_CHANGED,
        EVENT_FAIL;

    }
}

