/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.settings;

import carpet.settings.ParsedRule;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.settings.TISCMRule;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TISCMRules {
    private static final Map<String, TISCMRule> RULES_BY_NAME = Maps.newLinkedHashMap();
    private static final Map<ParsedRule<?>, TISCMRule> RULES_BY_CM_RULE = Maps.newLinkedHashMap();

    static void store(List<TISCMRule> rules) {
        for (TISCMRule rule : rules) {
            RULES_BY_NAME.put(rule.getName(), rule);
            RULES_BY_CM_RULE.put(rule.getCarpetRule(), rule);
            if (!rule.worksForCurrentMCVersion() || rule.allRestrictionsSatisfied()) continue;
            String reasons = String.join((CharSequence)"; ", rule.getAllRestrictionsFailReasons());
            CarpetTISAdditionMod.LOGGER.warn("Rule {} is disabled by mod restriction: {}", (Object)rule.getName(), (Object)reasons);
        }
    }

    public static Optional<TISCMRule> get(String ruleName) {
        return Optional.ofNullable(RULES_BY_NAME.get(ruleName));
    }

    public static Optional<TISCMRule> get(ParsedRule<?> carpetRule) {
        return Optional.ofNullable(RULES_BY_CM_RULE.get(carpetRule));
    }
}

