/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.carpet.loggerRestriction;

import carpet.logging.Logger;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.helpers.carpet.loggerRestriction.RestrictionCheckResult;
import carpettisaddition.helpers.carpet.loggerRestriction.RestrictiveLogger;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.Messenger;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CarpetLoggerRestriction {
    private static final Translator translator = new Translator("misc.logger_rule_switch");

    public static RestrictionCheckResult checkLoggerSubscribable(Logger logger, class_1657 player, String option) {
        return ((RestrictiveLogger)logger).canPlayerSubscribe(player, option);
    }

    public static boolean isLoggerSubscribable(Logger logger, class_1657 player, String option) {
        return CarpetLoggerRestriction.checkLoggerSubscribable(logger, player, option).isPassed();
    }

    public static void addLoggerRuleSwitch(Logger logger, String ruleName, Supplier<String> ruleValueProvider) {
        ((RestrictiveLogger)logger).addSubscriptionRestriction((player, option) -> {
            class_5250 message = Messenger.hover(translator.tr("permission_denied", logger.getLogName()), translator.tr("rule_hint", ruleName));
            if (!(player instanceof class_3222)) {
                CarpetTISAdditionMod.LOGGER.warn("subscriptionChecker receives a player {} that is not a ServerPlayerEntity", (Object)player);
                return RestrictionCheckResult.ok();
            }
            class_3222 serverPlayer = (class_3222)player;
            if (CarpetModUtil.canUseCarpetCommand(serverPlayer.method_5671())) {
                Messenger.click(message, Messenger.ClickEvents.suggestCommand("/carpet " + ruleName));
            }
            return RestrictionCheckResult.bool(CarpetModUtil.canUseCommand(serverPlayer.method_5671(), ruleValueProvider.get()), message);
        });
    }
}

