/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.ticket;

import carpet.logging.Logger;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.WorldUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.deobfuscator.StackTracePrinter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_5250;

public class TicketLogger
extends AbstractLogger {
    public static final String NAME = "ticket";
    private static final TicketLogger INSTANCE = new TicketLogger();
    private final List<class_3230> tickTypes = Lists.newArrayList();

    public TicketLogger() {
        super(NAME, false);
    }

    public static TicketLogger getInstance() {
        return INSTANCE;
    }

    public void addTicketType(class_3230 ticketType) {
        this.tickTypes.add(ticketType);
    }

    private String[] getLoggingSuggestions() {
        List<String> suggestions = this.tickTypes.stream().map(class_3230::toString).collect(Collectors.toList());
        suggestions.add(TicketLogger.createCompoundOption(class_3230.field_19280.toString(), class_3230.field_14033.toString()));
        suggestions.add(TicketLogger.createCompoundOption(class_3230.field_19280.toString(), class_3230.field_17264.toString()));
        return TicketLogger.wrapOptions(suggestions.toArray(new String[0]));
    }

    @Override
    public Logger createCarpetLogger() {
        return new Logger(TISAdditionLoggerRegistry.getLoggerField(NAME), NAME, class_3230.field_19280.toString(), null, false){

            public String[] getOptions() {
                return TicketLogger.this.getLoggingSuggestions();
            }
        };
    }

    private String formatSize(int range) {
        range = Math.max(range, 0);
        int length = range * 2 - 1;
        return String.format("%d * %d", length, length);
    }

    private void onManipulateTicket(class_3218 world, long position, class_3228 chunkTicket, ActionType actionType) {
        this.log(option -> {
            class_3230 chunkTicketType = chunkTicket.method_14281();
            if (Arrays.asList(option.split("[,. ]")).contains(chunkTicketType.toString())) {
                long expiryTicks = chunkTicketType.method_20629();
                class_1923 pos = new class_1923(position);
                int level = chunkTicket.method_14283();
                return new class_5250[]{Messenger.c(Messenger.fancy(Messenger.s((Object)String.format("[%s] ", WorldUtils.getWorldTime((class_1937)world)), "g"), this.tr("time_detail", DimensionWrapper.of((class_1937)world).getIdentifierString(), WorldUtils.getWorldTime((class_1937)world)), null), this.tr("message", Messenger.fancy(Messenger.s((Object)chunkTicketType.toString(), "d"), this.tr("ticket_detail", chunkTicket.method_14283(), expiryTicks > 0L ? Messenger.s(expiryTicks + " gt") : this.tr("permanent", new Object[0]), this.formatSize(32 - level), this.formatSize(33 - level), this.formatSize(34 - level)), null), actionType.getText(this.getTranslator()), Messenger.coord(pos, DimensionWrapper.of((class_1937)world))), "w  ", StackTracePrinter.makeSymbol(this.getClass()))};
            }
            return null;
        });
    }

    public static void onAddTicket(class_3218 world, long position, class_3228 chunkTicket) {
        if (TISAdditionLoggerRegistry.__ticket) {
            INSTANCE.onManipulateTicket(world, position, chunkTicket, ActionType.ADD);
        }
    }

    public static void onRemoveTicket(class_3218 world, long position, class_3228 chunkTicket) {
        if (TISAdditionLoggerRegistry.__ticket) {
            INSTANCE.onManipulateTicket(world, position, chunkTicket, ActionType.REMOVE);
        }
    }

    private static enum ActionType {
        ADD("l", "added"),
        REMOVE("r", "removed");

        private final String color;
        private final String translation;

        private ActionType(String color, String translation) {
            this.color = color;
            this.translation = translation;
        }

        private class_5250 getText(Translator translator) {
            return Messenger.formatting(translator.tr(this.translation, new Object[0]), this.color);
        }
    }
}

