/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.EventSource;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1953;
import net.minecraft.class_2554;

public class ScheduleTileTickEvent
extends BaseEvent {
    private final int delay;
    private final class_1953 priority;
    private final Boolean success;

    public ScheduleTileTickEvent(EventSource eventSource, int delay, class_1953 priority, Boolean success) {
        super(EventType.EVENT, "schedule_tile_tick", eventSource);
        this.delay = delay;
        this.priority = priority;
        this.success = success;
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(Messenger.formatting(this.tr("scheduled", new Object[0]), "c"));
        list.add(Messenger.getSpaceText());
        list.add(Messenger.fancy(Messenger.formatting(this.tr("tiletick_event", new Object[0]), "c"), Messenger.c(this.tr("delay", new Object[0]), String.format("w : %dgt\n", this.delay), this.tr("priority", new Object[0]), String.format("w : %d (%s)", this.priority.method_8681(), this.priority)), null));
        if (this.success != null) {
            list.add("w  ");
            list.add(MicroTimingUtil.getSuccessText(this.success, false));
        }
        return Messenger.c(list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleTileTickEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScheduleTileTickEvent that = (ScheduleTileTickEvent)o;
        return this.delay == that.delay && this.priority == that.priority && Objects.equals(this.success, that.success);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay, this.priority);
    }
}

