/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.raid;

import carpettisaddition.commands.raid.RaidWithIdAndWorld;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_3765;

public class RaidLogger
extends AbstractLogger {
    public static final String NAME = "raid";
    private static final RaidLogger instance = new RaidLogger();

    public RaidLogger() {
        super(NAME, true);
    }

    public static RaidLogger getInstance() {
        return instance;
    }

    public void onRaidCreated(class_3765 raid) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_2554[]{Messenger.c(this.tr("created", ((RaidWithIdAndWorld)raid).getRaidId$TISCM()), "g  @ ", Messenger.coord("w", (class_2382)raid.method_16495(), DimensionWrapper.of((class_1937)((RaidWithIdAndWorld)raid).getRaidWorld$TISCM())))});
    }

    public void onRaidInvalidated(class_3765 raid, InvalidateReason reason) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_2554[]{Messenger.c(this.tr("invalidated", ((RaidWithIdAndWorld)raid).getRaidId$TISCM(), reason.toText()))});
    }

    public void onBadOmenLevelIncreased(class_3765 raid, int badOmenLevel) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_2554[]{Messenger.c(this.tr("bad_omen_level_increased", ((RaidWithIdAndWorld)raid).getRaidId$TISCM(), badOmenLevel))});
    }

    public void onCenterMoved(class_3765 raid, class_2338 pos) {
        if (!TISAdditionLoggerRegistry.__raid) {
            return;
        }
        this.log(() -> new class_2554[]{Messenger.c(this.tr("center_moved", ((RaidWithIdAndWorld)raid).getRaidId$TISCM(), Messenger.coord((class_2382)pos, DimensionWrapper.of((class_1937)((RaidWithIdAndWorld)raid).getRaidWorld$TISCM()))))});
    }

    public static enum InvalidateReason {
        DIFFICULTY_PEACEFUL,
        GAMERULE_DISABLE,
        POI_REMOVED_BEFORE_SPAWN,
        TIME_OUT,
        RAIDER_CANNOT_SPAWN,
        RAID_VICTORY,
        RAID_DEFEAT;

        private static final Translator TRANSLATOR;

        public String getName() {
            return this.name().toLowerCase();
        }

        public class_2554 toText() {
            return TRANSLATOR.tr(this.getName(), new Object[0]);
        }

        static {
            TRANSLATOR = RaidLogger.getInstance().getTranslator().getDerivedTranslator("raid_invalidate_reason");
        }
    }
}

