/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.tweaks.logger.explosion;

import carpet.logging.logHelpers.ExplosionLogHelper;
import carpettisaddition.helpers.carpet.tweaks.logger.explosion.ExplosionLogHelperWithEntity;
import carpettisaddition.helpers.carpet.tweaks.logger.explosion.ITntEntity;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExplosionLogHelper.class})
public abstract class ExplosionLogHelperMixin
implements ExplosionLogHelperWithEntity {
    private class_1297 entity$TISCM = null;

    @Override
    public void setEntity$TISCM(class_1297 entity$TISCM) {
        this.entity$TISCM = entity$TISCM;
    }

    private double calculateAngle(class_243 velocity) {
        double angle;
        double vx = velocity.method_10216();
        double vz = velocity.method_10215();
        if (vz != 0.0) {
            angle = Math.atan(vx / vz);
            if (vz > 0.0) {
                angle += Math.PI;
            } else if (vx > 0.0) {
                angle += Math.PI * 2;
            }
        } else {
            angle = vx > 0.0 ? 4.71238898038469 : 1.5707963267948966;
        }
        return angle;
    }

    @Inject(method={"lambda$onExplosionDone$1"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void attachBlockDestroyedWarning(long gametime, String option, CallbackInfoReturnable<class_2554[]> cir) {
        ITntEntity iTntEntity;
        if (this.entity$TISCM instanceof class_1541 && (iTntEntity = (ITntEntity)this.entity$TISCM).dataRecorded()) {
            ArrayList messages = Lists.newArrayList();
            for (class_2554 text : (class_2554[])cir.getReturnValue()) {
                if (!(text instanceof class_2554)) continue;
                messages.add(text);
            }
            String angleString = String.valueOf(this.calculateAngle(iTntEntity.getInitializedVelocity()));
            String posString = TextUtils.coord(iTntEntity.getInitializedPosition());
            class_2554 tntText = Messenger.fancy("r", Messenger.s("[TNT]"), Messenger.c("w Initialized Data\n", String.format("w - Position: %s\n", posString), String.format("w - Angle: %s", angleString)), Messenger.ClickEvents.suggestCommand(posString + " " + angleString));
            switch (option) {
                case "brief": {
                    class_2554 lastMessage = (class_2554)messages.get(messages.size() - 1);
                    messages.set(messages.size() - 1, Messenger.c(lastMessage, "w  ", tntText));
                    break;
                }
                case "full": {
                    messages.add(Messenger.c(Messenger.s("  "), tntText));
                }
            }
            cir.setReturnValue((Object)messages.toArray(new class_2554[0]));
        }
    }
}

