/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.settings;

import carpet.settings.ParsedRule;
import carpettisaddition.settings.Rule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.conditionalmixin.api.util.VersionChecker;

public class TISCMRule {
    private final Field field;
    private final ParsedRule<?> carpetRule;
    private final ParsedRestrictions allRestrictions;
    private final ParsedRestrictions mcRestrictions;

    public TISCMRule(Rule annotation, Field field, ParsedRule<?> carpetRule) {
        this.field = field;
        this.carpetRule = carpetRule;
        this.allRestrictions = new ParsedRestrictions(annotation.restrictions(), c -> true);
        this.mcRestrictions = new ParsedRestrictions(annotation.restrictions(), c -> c.value().equals("minecraft"));
    }

    public ParsedRule<?> getCarpetRule() {
        return this.carpetRule;
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean allRestrictionsSatisfied() {
        return this.allRestrictions.satisfied;
    }

    public List<String> getAllRestrictionsFailReasons() {
        return this.allRestrictions.badReasons;
    }

    public boolean worksForCurrentMCVersion() {
        return this.mcRestrictions.satisfied;
    }

    public List<String> getMCVersionFailReasons() {
        return this.allRestrictions.badReasons;
    }

    private static class ParsedRestrictions {
        public final boolean satisfied;
        public final List<String> badReasons;

        public ParsedRestrictions(Restriction[] restrictions, Predicate<Condition> filter) {
            ArrayList badReasons = Lists.newArrayList();
            boolean ok = restrictions.length == 0;
            for (Restriction r : restrictions) {
                String s;
                List badR = Arrays.stream(r.require()).filter(filter).filter(c -> !ParsedRestrictions.checkCondition(c)).collect(Collectors.toList());
                List badC = Arrays.stream(r.conflict()).filter(filter).filter(ParsedRestrictions::checkCondition).collect(Collectors.toList());
                ok |= badR.isEmpty() && badC.isEmpty();
                if (!badR.isEmpty()) {
                    s = badR.stream().map(ParsedRestrictions::formatCondition).collect(Collectors.joining(", "));
                    badReasons.add("requirement " + s + " unmet");
                }
                if (badC.isEmpty()) continue;
                s = badC.stream().map(ParsedRestrictions::formatCondition).collect(Collectors.joining(", "));
                badReasons.add("conflict " + s + " found");
            }
            this.satisfied = ok;
            this.badReasons = ImmutableList.copyOf((Collection)badReasons);
        }

        private static boolean checkCondition(Condition c) {
            if (c.type() != Condition.Type.MOD) {
                throw new IllegalArgumentException("Only conditions of type MOD are supported");
            }
            return VersionChecker.doesModVersionSatisfyPredicate((String)c.value(), Arrays.asList(c.versionPredicates()));
        }

        private static String formatCondition(Condition c) {
            Object s = c.value();
            if (c.versionPredicates().length > 0) {
                s = (String)s + " " + String.join((CharSequence)"||", c.versionPredicates());
            }
            return "'" + (String)s + "'";
        }
    }
}

