/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.info;

import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandExtender;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.info.InfoSubcommand;
import carpettisaddition.commands.info.world.InfoWorldCommand;
import carpettisaddition.mixins.command.info.ServerWorldAccessor;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.WorldUtils;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_1949;
import net.minecraft.class_1953;
import net.minecraft.class_1954;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_3341;

public class InfoCommandExtension
extends AbstractCommand
implements CommandExtender {
    private static final InfoCommandExtension INSTANCE = new InfoCommandExtension();

    public static InfoCommandExtension getInstance() {
        return INSTANCE;
    }

    public InfoCommandExtension() {
        super("info");
    }

    @Override
    public void extendCommand(CommandTreeContext.Node context) {
        BiConsumer<String, InfoSubcommand> extend = (name, subcommand) -> {
            LiteralArgumentBuilder worldNode = class_2170.method_9247((String)name);
            subcommand.extendCommand(context.node((ArgumentBuilder<class_2168, ?>)worldNode));
            context.node.then((ArgumentBuilder)worldNode);
        };
        extend.accept("world", InfoWorldCommand.getInstance());
    }

    private <T> void appendTileTickInfo(List<class_2554> result, List<class_1954<T>> tileTickList, String title, long currentTime, Function<T, class_2554> nameGetter) {
        if (!tileTickList.isEmpty()) {
            result.add(Messenger.s(String.format(" - %s * %d", title, tileTickList.size())));
            for (class_1954<T> tt : tileTickList) {
                long time = tt.field_9321;
                class_1953 priority = tt.field_9320;
                result.add(Messenger.c("w     ", nameGetter.apply(tt.method_8683()), String.format("w : time = %d (+%dgt), priority = %d", time, time - currentTime, priority.method_8681())));
            }
        }
    }

    private void appendBlockEventInfo(List<class_2554> result, List<class_1919> blockEvents) {
        if (!blockEvents.isEmpty()) {
            result.add(Messenger.s(" - Queued Block Events * " + blockEvents.size()));
            for (class_1919 be : blockEvents) {
                result.add(Messenger.c("w     ", Messenger.block(be.method_8309()), String.format("w : id = %d, param = %d", be.method_8307(), be.method_8308())));
            }
        }
    }

    public Collection<class_2554> showMoreBlockInfo(class_2338 pos, class_1937 world) {
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        class_3341 bound = new class_3341((class_2382)pos, (class_2382)pos.method_10069(1, 1, 1));
        List blockTileTicks = ((class_1949)world.method_8397()).method_8672(bound, false, false);
        List liquidTileTicks = ((class_1949)world.method_8405()).method_8672(bound, false, false);
        this.appendTileTickInfo(result, blockTileTicks, "Block Tile ticks", WorldUtils.getWorldTime(world), Messenger::block);
        this.appendTileTickInfo(result, liquidTileTicks, "Fluid Tile ticks", WorldUtils.getWorldTime(world), Messenger::fluid);
        List<class_1919> blockEvents = ((ServerWorldAccessor)world).getPendingBlockActions().stream().filter(be -> be.method_8306().equals((Object)pos)).collect(Collectors.toList());
        this.appendBlockEventInfo(result, blockEvents);
        return result;
    }
}

