/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.chunk;

import carpettisaddition.commands.manipulate.chunk.ChunkManipulatorUtils;
import carpettisaddition.mixins.command.manipulate.chunk.HeightmapAccessor;
import carpettisaddition.mixins.command.manipulate.chunk.PalettedContainerAccessor;
import carpettisaddition.mixins.command.manipulate.chunk.ServerWorldAccessor;
import carpettisaddition.mixins.command.manipulate.chunk.WorldChunkAccessor;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.NanoTimer;
import carpettisaddition.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1919;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2168;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class ChunkEraser
extends TranslationContext {
    private final List<class_1923> chunkPosList;
    private final Map<class_1923, class_2818> chunks = Maps.newLinkedHashMap();
    private final class_2168 source;
    private final class_3218 world;
    private final Stats stats;
    private static final class_2804 FILLED_CHUNK_NIBBLE_ARRAY = (class_2804)class_156.method_656(() -> {
        byte[] bytes = new byte[2048];
        Arrays.fill(bytes, (byte)-1);
        return new class_2804(bytes);
    });

    protected ChunkEraser(Translator translator, List<class_1923> chunkPosList, class_2168 source) {
        super(translator);
        this.chunkPosList = chunkPosList;
        this.source = source;
        this.world = source.method_9225();
        this.stats = new Stats();
    }

    public CompletableFuture<Void> erase() {
        NanoTimer timer = new NanoTimer();
        TimeCosts timeCosts = new TimeCosts();
        for (class_1923 chunkPos : this.chunkPosList) {
            this.chunks.put(chunkPos, this.world.method_8497(chunkPos.field_9181, chunkPos.field_9180));
        }
        timeCosts.loading = timer.getElapsedSecRestart();
        this.reportChunkLoadingStats(timeCosts);
        this.eraseMatter();
        timeCosts.eraseMatter = timer.getElapsedSecRestart();
        this.reportMatterStats(timeCosts);
        return this.eraseLight().thenRunAsync(() -> {
            timeCosts.eraseLight = timer.getElapsedSecRestart();
            this.reportLightStats(timeCosts);
            timeCosts.total = timer.getTotalElapsedSec();
            this.reportFinalStats(timeCosts);
        }, (Executor)this.world.method_8503());
    }

    private void reportChunkLoadingStats(TimeCosts timeCosts) {
        if (timeCosts.loading >= 1.0) {
            Messenger.tell(this.source, this.tr("loading_summary", this.chunks.size(), StringUtils.fractionDigit(timeCosts.loading, 1)));
        }
    }

    private void reportMatterStats(TimeCosts timeCosts) {
        Messenger.tell(this.source, this.tr("matter_summary", this.chunks.size(), StringUtils.fractionDigit(timeCosts.eraseMatter, 1), this.stats.entity, this.stats.blockEntity, this.stats.tileTick, this.stats.blockEvent, this.stats.chunkSection));
        if (this.chunks.size() > 50) {
            Messenger.tell(this.source, this.tr("erase_light", new Object[0]));
        }
    }

    private void reportLightStats(TimeCosts timeCosts) {
        Messenger.tell(this.source, this.tr("light_summary", StringUtils.fractionDigit(timeCosts.eraseLight, 1)));
    }

    private void reportFinalStats(TimeCosts timeCosts) {
        Messenger.tell(this.source, Messenger.hover(this.tr("all_done", StringUtils.fractionDigit(timeCosts.total, 1)), this.tr("all_done_hover", StringUtils.fractionDigit(timeCosts.loading, 2), StringUtils.fractionDigit(timeCosts.eraseMatter, 2), StringUtils.fractionDigit(timeCosts.eraseLight, 2))));
    }

    private void eraseMatter() {
        for (class_1923 chunkPos : this.chunks.keySet()) {
            this.eraseOneChunk(chunkPos);
        }
        this.eraseDataStructures();
    }

    private static void clearCollection(@Nullable Collection<?> collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    private void eraseOneChunk(class_1923 chunkPos) {
        class_2818 chunk = Objects.requireNonNull(this.chunks.get(chunkPos));
        List<class_1297> entities = Arrays.stream(chunk.method_12215()).flatMap(Collection::stream).filter(entity -> !(entity instanceof class_1657)).collect(Collectors.toList());
        entities.forEach(class_1297::method_5650);
        this.stats.entity += entities.size();
        ArrayList bePos = Lists.newArrayList(chunk.method_12214().keySet());
        bePos.forEach(arg_0 -> ((class_3218)this.world).method_8544(arg_0));
        this.stats.blockEntity += bePos.size();
        this.stats.tileTick += this.world.method_14196().method_8671(chunk.method_12004(), true, true).size();
        this.stats.tileTick += this.world.method_14179().method_8671(chunk.method_12004(), true, true).size();
        ((WorldChunkAccessor)chunk).getPendingBlockEntityTags().clear();
        for (ShortList shortList : chunk.method_12012()) {
            if (shortList == null) continue;
            shortList.clear();
        }
        for (ShortList shortList : chunk.method_12006()) {
            if (shortList == null) continue;
            ChunkEraser.eraseChunkSectionBlocks((class_2826)shortList);
            ++this.stats.chunkSection;
        }
        chunk.method_12011().stream().map(Map.Entry::getValue).forEach(heightmap -> {
            int bottomY = 0;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    ((HeightmapAccessor)heightmap).invokeSet(x, z, bottomY);
                }
            }
        });
        chunk.method_12008(true);
        ChunkManipulatorUtils.refreshChunk(this.world, chunk);
    }

    private static void eraseChunkSectionBlocks(class_2826 chunkSection) {
        class_2841 container = chunkSection.method_12265();
        PalettedContainerAccessor accessor = (PalettedContainerAccessor)container;
        container.method_12334();
        accessor.invokeSetPaletteSize(0);
        container.method_12335();
        chunkSection.method_12253();
    }

    private void eraseDataStructures() {
        ObjectLinkedOpenHashSet<class_1919> blockEventQueue = ((ServerWorldAccessor)this.world).getPendingBlockActions();
        ObjectListIterator iterator = blockEventQueue.iterator();
        while (iterator.hasNext()) {
            class_1919 blockAction = (class_1919)iterator.next();
            if (!this.chunks.containsKey(new class_1923(blockAction.method_8306()))) continue;
            ++this.stats.blockEvent;
            iterator.remove();
        }
    }

    private CompletableFuture<Void> eraseLight() {
        ArrayList futures = Lists.newArrayList();
        for (class_2818 chunk : this.chunks.values()) {
            futures.add(this.relightChunk(this.world.method_14178().method_17293(), chunk));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<Void> relightChunk(class_3227 lightingProvider, class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int minY = -1;
        int maxY = 17;
        for (int y = minY; y < maxY; ++y) {
            class_4076 chunkSectionPos = class_4076.method_18681((class_1923)chunkPos, (int)y);
            lightingProvider.method_15558(class_1944.field_9282, chunkSectionPos, new class_2804());
            lightingProvider.method_15558(class_1944.field_9284, chunkSectionPos, FILLED_CHUNK_NIBBLE_ARRAY.method_12144());
        }
        return ChunkManipulatorUtils.enqueueDummyLightingTask(lightingProvider, chunkPos).thenRunAsync(() -> ChunkManipulatorUtils.refreshChunkLight(this.world, chunk), (Executor)this.world.method_8503());
    }

    private static class Stats {
        public int entity = 0;
        public int blockEntity = 0;
        public int tileTick = 0;
        public int blockEvent = 0;
        public int chunkSection = 0;

        private Stats() {
        }
    }

    private static class TimeCosts {
        public double loading = 0.0;
        public double eraseMatter = 0.0;
        public double eraseLight = 0.0;
        public double total = 0.0;

        private TimeCosts() {
        }
    }
}

