/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.container.controller;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.manipulate.container.controller.AbstractContainerController;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteBlockEventEvent;
import carpettisaddition.mixins.command.manipulate.container.ServerWorldAccessor;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class BlockEventQueueController
extends AbstractContainerController {
    public BlockEventQueueController() {
        super("block_event");
    }

    public int removeAt(class_2168 source, class_2338 blockPos) {
        int counter = 0;
        ObjectLinkedOpenHashSet<class_1919> queue = ((ServerWorldAccessor)source.method_9225()).getPendingBlockActions();
        ObjectListIterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            class_1919 be = (class_1919)iterator.next();
            if (!be.method_8306().equals((Object)blockPos)) continue;
            iterator.remove();
            ++counter;
        }
        Messenger.tell(source, Messenger.tr("removed", counter), true);
        return counter;
    }

    public int addEvent(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_2338 blockPos = class_2262.method_9696(context, (String)"pos");
        class_2248 block = class_2257.method_9655(context, (String)"block").method_9494().method_11614();
        int type = IntegerArgumentType.getInteger(context, (String)"type");
        int data = IntegerArgumentType.getInteger(context, (String)"data");
        class_1919 blockAction = new class_1919(blockPos, block, type, data);
        Messenger.tell(source, this.tr("scheduled", Messenger.fancy(this.tr("item_name", new Object[0]), ExecuteBlockEventEvent.getMessageExtraMessengerHoverText(blockAction), null), Messenger.coord((class_2382)blockPos, DimensionWrapper.of((class_1937)source.method_9225()))), true);
        source.method_9225().method_8427(blockPos, block, type, data);
        return 1;
    }

    @Override
    public ArgumentBuilder<class_2168, ?> getCommandNode(CommandTreeContext context) {
        return super.getCommandNode(context).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> this.removeAt((class_2168)c.getSource(), class_2262.method_9696((CommandContext)c, (String)"pos"))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).then(class_2170.method_9244((String)"type", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"data", (ArgumentType)IntegerArgumentType.integer()).executes(this::addEvent))))));
    }
}

