/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.carpet.shape;

import carpet.script.utils.ShapeDispatcher;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpettisaddition.helpers.carpet.shape.ShapeHolder;
import carpettisaddition.mixins.carpet.shape.ShapeDispatcherLineAccessor;
import carpettisaddition.mixins.carpet.shape.ShapeDispatcherSphereAccessor;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ShapeUtil {
    private static Map<String, Value> getBasicParamMap(DimensionWrapper dimension, @Nullable Long color) {
        HashMap params = Maps.newHashMap();
        params.put("dim", new StringValue(dimension.getIdentifierString()));
        params.put("duration", new NumericValue(Integer.MAX_VALUE));
        if (color != null) {
            params.put("color", new NumericValue(color.longValue()));
        }
        return params;
    }

    public static ShapeHolder<ShapeDispatcher.Line> createLine(class_243 from, class_243 to, DimensionWrapper dimension, @Nullable Long color) {
        Map<String, Value> boxParams = ShapeUtil.getBasicParamMap(dimension, color);
        boxParams.put("shape", (Value)new StringValue("line"));
        boxParams.put("from", (Value)ShapeUtil.posToList(from));
        boxParams.put("to", (Value)ShapeUtil.posToList(to));
        return new ShapeHolder<ShapeDispatcher.Line>(ShapeDispatcherLineAccessor.invokeConstructor(), boxParams);
    }

    public static ShapeHolder<ShapeDispatcher.Box> createBox(class_243 from, class_243 to, DimensionWrapper dimension, @Nullable Long color) {
        Map<String, Value> boxParams = ShapeUtil.getBasicParamMap(dimension, color);
        boxParams.put("shape", (Value)new StringValue("box"));
        boxParams.put("from", (Value)ShapeUtil.posToList(from));
        boxParams.put("to", (Value)ShapeUtil.posToList(to));
        return new ShapeHolder<ShapeDispatcher.Box>(new ShapeDispatcher.Box(), boxParams);
    }

    public static ShapeHolder<ShapeDispatcher.Sphere> createSphere(class_243 center, float radius, DimensionWrapper dimension, @Nullable Long color) {
        Map<String, Value> boxParams = ShapeUtil.getBasicParamMap(dimension, color);
        boxParams.put("shape", (Value)new StringValue("sphere"));
        boxParams.put("center", (Value)ShapeUtil.posToList(center));
        boxParams.put("radius", (Value)new NumericValue((double)radius));
        return new ShapeHolder<ShapeDispatcher.Sphere>(ShapeDispatcherSphereAccessor.invokeConstructor(), boxParams);
    }

    public static ShapeHolder<ShapeDispatcher.Text> createLabel(class_2561 text, class_243 pos, DimensionWrapper dimension, @Nullable Long color) {
        Map<String, Value> textParams = ShapeUtil.getBasicParamMap(dimension, color);
        textParams.put("shape", (Value)new StringValue("label"));
        textParams.put("pos", (Value)ShapeUtil.posToList(pos));
        textParams.put("text", (Value)new FormattedTextValue(text));
        textParams.put("align", (Value)new StringValue("UE_S8LmakpJ5ARpe"));
        return new ShapeHolder<ShapeDispatcher.Text>(new ShapeDispatcher.Text(), textParams);
    }

    private static ListValue posToList(class_243 vec3d) {
        return ListValue.of((Value[])new Value[]{new NumericValue(vec3d.method_10216()), new NumericValue(vec3d.method_10214()), new NumericValue(vec3d.method_10215())});
    }
}

