/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.fakePlayerNameExtra;

import carpet.commands.PlayerCommand;
import carpettisaddition.CarpetTISAdditionSettings;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PlayerCommand.class})
public abstract class PlayerCommandMixin {
    @Unique
    private static String getDecoratedPlayerName(String playerName) {
        String rulePrefix = CarpetTISAdditionSettings.fakePlayerNamePrefix;
        String ruleSuffix = CarpetTISAdditionSettings.fakePlayerNameSuffix;
        if (!rulePrefix.equals("#none") && !playerName.startsWith(rulePrefix)) {
            playerName = rulePrefix + playerName;
        }
        if (!ruleSuffix.equals("#none") && !playerName.endsWith(ruleSuffix)) {
            playerName = playerName + ruleSuffix;
        }
        return playerName;
    }

    @ModifyExpressionValue(method={"spawn"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;")}, require=2, remap=false)
    private static String getStringWithPrefixAtSpawn(String value) {
        return PlayerCommandMixin.getDecoratedPlayerName(value);
    }

    @ModifyExpressionValue(method={"cantSpawn"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;")}, require=1, remap=false)
    private static String getStringWithPrefixAtCantSpawn(String value) {
        return PlayerCommandMixin.getDecoratedPlayerName(value);
    }

    @ModifyExpressionValue(method={"spawn"}, at={@At(value="CONSTANT", args={"intValue=40"})}, require=1, remap=false)
    private static int nameLengthLimit(int value) {
        return 16;
    }
}

