/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.optimizedFastEntityMovement;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMContext;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMUtil;
import carpettisaddition.utils.mixin.testers.LithiumEntityMovementOptimizationTester;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.stream.Stream;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Restriction(conflict={@Condition(type=Condition.Type.TESTER, tester=LithiumEntityMovementOptimizationTester.class)})
@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Unique
    private static final ThreadLocal<OFEMContext> ofemContext = ThreadLocal.withInitial(() -> null);

    @WrapOperation(method={"adjustMovementForCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Box;Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityContext;Lnet/minecraft/util/ReusableStream;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/stream/Stream;")})
    private static Stream<class_265> optimizedFastEntityMovement_dontUseThatLargeBlockCollisions(class_1937 world, class_1297 entity, class_238 box, Operation<Stream<class_265>> original, @Local(argsOnly=true) class_243 movement) {
        boolean ok;
        if (CarpetTISAdditionSettings.optimizedFastEntityMovement && (ok = OFEMUtil.checkMovement(movement))) {
            ofemContext.set(OFEMUtil.createContext(world, entity));
            return Stream.empty();
        }
        ofemContext.remove();
        return (Stream)original.call(new Object[]{world, entity, box});
    }

    @ModifyArgs(method={"adjustMovementForCollisions(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Box;Lnet/minecraft/util/ReusableStream;)Lnet/minecraft/util/math/Vec3d;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/shape/VoxelShapes;calculateMaxOffset(Lnet/minecraft/util/math/Direction$Axis;Lnet/minecraft/util/math/Box;Ljava/util/stream/Stream;D)D"), require=4)
    private static void optimizedFastEntityMovement_useTheAxisOnlyBlockCollisionsForSpeed(Args args) {
        OFEMContext ctx = ofemContext.get();
        if (ctx != null) {
            class_2350.class_2351 axis = (class_2350.class_2351)args.get(0);
            class_238 entityBoundingBox = (class_238)args.get(1);
            Stream entityAndBorderCollisions = (Stream)args.get(2);
            double maxDist = (Double)args.get(3);
            ctx.axis = axis;
            ctx.movementOnAxis = maxDist;
            ctx.entityBoundingBox = entityBoundingBox;
            Stream<class_265> blockCollisions = OFEMUtil.getAxisOnlyBlockCollision(ctx);
            args.set(2, Stream.concat(entityAndBorderCollisions, blockCollisions));
        }
    }
}

