/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.settings;

import carpet.settings.ParsedRule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.mixins.settings.ParsedRuleAccessor;
import carpettisaddition.mixins.settings.SettingsManagerAccessor;
import carpettisaddition.network.TISCMProtocolRuleListener;
import carpettisaddition.settings.Rule;
import carpettisaddition.settings.TISCMRule;
import carpettisaddition.settings.TISCMRules;
import carpettisaddition.settings.validator.AbstractValidator;
import carpettisaddition.translations.TISAdditionTranslations;
import carpettisaddition.translations.TranslationConstants;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CarpetRuleRegistrar {
    private static boolean hasRegistered = false;
    private final SettingsManager settingsManager;
    private final List<TISCMRule> rules = Lists.newArrayList();

    private CarpetRuleRegistrar(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static void register(SettingsManager settingsManager, Class<?> settingsClass) {
        if (hasRegistered) {
            throw new IllegalStateException("Already registered");
        }
        CarpetRuleRegistrar registrar = new CarpetRuleRegistrar(settingsManager);
        registrar.parseSettingsClass(settingsClass);
        registrar.registerToCarpet();
        TISCMRules.store(registrar.rules);
        hasRegistered = true;
    }

    public void parseSettingsClass(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            Rule rule = field.getAnnotation(Rule.class);
            if (rule == null) continue;
            this.parseRule(field, rule);
        }
    }

    private static Class<? extends AbstractValidator>[] extractValidators(Rule rule) {
        ArrayList validators = Lists.newArrayList((Object[])rule.validators());
        if (Arrays.asList(rule.categories()).contains("TISCM_protocol")) {
            validators.add(TISCMProtocolRuleListener.class);
        }
        return validators.toArray(new Class[0]);
    }

    private void parseRule(final Field field, final Rule rule) {
        final Class[] validators = CarpetRuleRegistrar.extractValidators(rule);
        carpet.settings.Rule cmRule = new carpet.settings.Rule(){
            private final String basedKey = TranslationConstants.CARPET_TRANSLATIONS_KEY_PREFIX + "rule." + this.name() + ".";

            @Nullable
            private String tr(String key) {
                return TISAdditionTranslations.getTranslationString("en_us", this.basedKey + key);
            }

            public String desc() {
                String desc = this.tr("desc");
                if (desc == null) {
                    CarpetTISAdditionMod.LOGGER.warn("Rule {} has no translated desc", (Object)this.name());
                }
                return desc != null ? desc : "";
            }

            public String[] extra() {
                String message;
                ArrayList extraMessages = Lists.newArrayList();
                int i = 0;
                while ((message = this.tr("extra." + i)) != null) {
                    extraMessages.add(message);
                    ++i;
                }
                return extraMessages.toArray(new String[0]);
            }

            public String name() {
                return field.getName();
            }

            public String[] category() {
                return rule.categories();
            }

            public String[] options() {
                return rule.options();
            }

            public boolean strict() {
                return rule.strict();
            }

            public Class<? extends Validator>[] validate() {
                return validators;
            }

            public Class<? extends Annotation> annotationType() {
                return rule.annotationType();
            }
        };
        ParsedRule carpetRule = ParsedRuleAccessor.invokeConstructor(field, cmRule);
        this.rules.add(new TISCMRule(rule, field, carpetRule));
    }

    public void registerToCarpet() {
        for (TISCMRule rule : this.rules) {
            ParsedRule<?> existingRule = ((SettingsManagerAccessor)this.settingsManager).getRules$TISCM().put(rule.getName(), rule.getCarpetRule());
            if (existingRule == null) continue;
            CarpetTISAdditionServer.LOGGER.warn("[TISCM] Overwriting existing rule {}", existingRule);
        }
    }
}

