/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.translations;

import carpet.CarpetSettings;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.mixins.translations.StyleAccessor;
import carpettisaddition.translations.ServerPlayerEntityWithClientLanguage;
import carpettisaddition.translations.TranslationConstants;
import carpettisaddition.translations.TranslationLoader;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TISAdditionTranslations {
    private static final Map<String, Map<String, String>> translationStorage = Maps.newLinkedHashMap();

    public static void loadTranslations() {
        TranslationLoader.loadTranslations(translationStorage);
    }

    public static Collection<String> getLanguages() {
        return Collections.unmodifiableSet(translationStorage.keySet());
    }

    @NotNull
    public static Map<String, String> getTranslations(String lang) {
        return translationStorage.getOrDefault(lang, Collections.emptyMap());
    }

    public static String getServerLanguage() {
        return CarpetSettings.language.equalsIgnoreCase("none") ? "en_us" : CarpetSettings.language;
    }

    @Nullable
    public static String getTranslationString(String lang, String key) {
        return TISAdditionTranslations.getTranslations(lang.toLowerCase()).get(key);
    }

    public static class_2554 translate(class_2554 text, String lang) {
        return TISAdditionTranslations.translateText(text, lang);
    }

    public static class_2554 translate(class_2554 text) {
        return TISAdditionTranslations.translate(text, TISAdditionTranslations.getServerLanguage());
    }

    public static class_2554 translate(class_2554 text, class_3222 player) {
        if (CarpetTISAdditionSettings.ultraSecretSetting.equals("translation")) {
            return TISAdditionTranslations.translate(text);
        }
        return TISAdditionTranslations.translate(text, ((ServerPlayerEntityWithClientLanguage)player).getClientLanguage$TISCM());
    }

    private static class_2554 translateText(class_2554 text, @NotNull String lang) {
        boolean[] translationRequired = new boolean[]{false};
        TISAdditionTranslations.forEachTISCMTranslationText(text, lang, (txt, msgKeyString) -> {
            translationRequired[0] = true;
            return txt;
        });
        if (!translationRequired[0]) {
            return text;
        }
        return TISAdditionTranslations.forEachTISCMTranslationText(Messenger.copy(text), lang, (txt, msgKeyString) -> {
            class_2554 newText;
            String txtKey = txt.method_11022();
            Object[] txtArgs = txt.method_11023();
            if (msgKeyString == null) {
                CarpetTISAdditionServer.LOGGER.warn("TISCM: Unknown translation key {}", (Object)txtKey);
                return txt;
            }
            try {
                newText = Messenger.format(msgKeyString, txtArgs);
            }
            catch (IllegalArgumentException e) {
                newText = Messenger.s(msgKeyString);
            }
            newText.method_10855().addAll(txt.method_10855());
            newText.method_10862(txt.method_10866());
            return newText;
        });
    }

    private static class_2554 forEachTISCMTranslationText(class_2554 text, @NotNull String lang, TextModifier modifier) {
        class_2554 newHoverText;
        class_2554 oldHoverText;
        class_2568 hoverEvent;
        class_2554 newText;
        int i;
        if (text instanceof class_2588) {
            class_2588 translatableText = (class_2588)text;
            Object[] args = translatableText.method_11023();
            for (i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof class_2554) || (newText = TISAdditionTranslations.forEachTISCMTranslationText((class_2554)arg, lang, modifier)) == arg) continue;
                args[i] = newText;
            }
            if (translatableText.method_11022().startsWith(TranslationConstants.TRANSLATION_KEY_PREFIX)) {
                String msgKeyString = TISAdditionTranslations.getTranslationString(lang, translatableText.method_11022());
                if (msgKeyString == null && !lang.equals("en_us")) {
                    msgKeyString = TISAdditionTranslations.getTranslationString("en_us", translatableText.method_11022());
                }
                text = modifier.apply(translatableText, msgKeyString);
            }
        }
        if ((hoverEvent = ((StyleAccessor)text.method_10866()).getHoverEvent$TISCM()) != null && (oldHoverText = (class_2554)class_156.method_656(() -> {
            class_2561 hoverEventText = hoverEvent.method_10891();
            if (hoverEvent.method_10892() == class_2568.class_2569.field_11762 && hoverEventText instanceof class_2554) {
                return (class_2554)hoverEventText;
            }
            return null;
        })) != null && (newHoverText = TISAdditionTranslations.forEachTISCMTranslationText(oldHoverText, lang, modifier)) != oldHoverText) {
            Messenger.hover(text, newHoverText);
        }
        List siblings = text.method_10855();
        for (i = 0; i < siblings.size(); ++i) {
            class_2561 sibling = (class_2561)siblings.get(i);
            newText = TISAdditionTranslations.forEachTISCMTranslationText((class_2554)sibling, lang, modifier);
            if (newText == sibling) continue;
            siblings.set(i, newText);
        }
        return text;
    }

    @FunctionalInterface
    private static interface TextModifier {
        public class_2554 apply(class_2588 var1, @Nullable String var2);
    }
}

