/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.common.counter;

import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.common.counter.DyeCounter;
import carpettisaddition.commands.common.counter.DyeCounterKey;
import carpettisaddition.commands.common.counter.DyeCounterProvider;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DyeCounterCommand<Key extends DyeCounterKey, Counter extends DyeCounter<Key>>
extends AbstractCommand
implements DyeCounterProvider<Key, DyeCounter<Key>> {
    public static final List<String> COLORS = Arrays.stream(class_1767.values()).map(cl -> cl.method_7792().toLowerCase()).collect(Collectors.toList());
    protected final Map<class_1767, Counter> counter = Maps.newEnumMap(class_1767.class);
    protected final String commandPrefix;
    private final Translator baseTr = new Translator("command.dye_counter");

    public DyeCounterCommand(String name, String commandPrefix) {
        super(name);
        this.commandPrefix = commandPrefix;
        for (class_1767 color : class_1767.values()) {
            this.counter.put(color, this.createCounterForColor(color));
        }
    }

    @Override
    @NotNull
    public Counter getCounter(@NotNull class_1767 color) {
        return (Counter)((DyeCounter)this.counter.get(Objects.requireNonNull(color)));
    }

    @Override
    @Nullable
    public Counter getCounter(String color) {
        class_1767 dyeColor;
        try {
            dyeColor = class_1767.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.getCounter(dyeColor);
    }

    protected abstract Counter createCounterForColor(class_1767 var1);

    protected abstract Object getRuleValue();

    protected abstract boolean isActivated();

    protected void addFor(class_1767 color, Key key, long count) {
        ((DyeCounter)this.counter.get(color)).addForKey(key, count);
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.commandPrefix).requires(s -> CarpetModUtil.canUseCommand(s, this.getRuleValue()))).executes(c -> this.reportAll((class_2168)c.getSource()))).then(class_2170.method_9247((String)"reset").executes(c -> this.resetAll((class_2168)c.getSource())))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(COLORS, (SuggestionsBuilder)b)).executes(c -> this.report((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color"), false))).then(class_2170.method_9247((String)"realtime").executes(c -> this.report((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color"), true)))).then(class_2170.method_9247((String)"reset").executes(c -> this.resetSingle((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"color")))));
        context.dispatcher.register(root);
    }

    private int report(class_2168 source, String color, boolean realtime) {
        return this.doWithCounter(source, color, counter -> {
            Messenger.tell(source, counter.report(realtime));
            return 1;
        });
    }

    private int reportAll(class_2168 source) {
        int printed = 0;
        for (DyeCounter counter : this.counter.values()) {
            List<class_5250> lines = counter.report(false);
            if (lines.size() <= 1) continue;
            Messenger.tell(source, Messenger.s(""));
            ++printed;
            Messenger.tell(source, lines);
        }
        if (printed == 0) {
            Messenger.tell(source, this.baseTr.tr("no_item_yet", this.tr("key_name", new Object[0])));
        }
        return printed;
    }

    private int doWithCounter(class_2168 source, String color, Function<Counter, Integer> consumer) {
        return Optional.ofNullable(this.getCounter(color)).map(consumer).orElseGet(() -> {
            Messenger.tell(source, this.baseTr.tr("unknown_color", color));
            return 0;
        });
    }

    private int resetAll(class_2168 source) {
        for (DyeCounter counter : this.counter.values()) {
            counter.reset();
        }
        Messenger.tell(source, this.baseTr.tr("restart_all", this.tr("counter_name", new Object[0])), true);
        return 1;
    }

    private int resetSingle(class_2168 source, String color) {
        return this.doWithCounter(source, color, counter -> {
            counter.reset();
            Messenger.tell(source, this.baseTr.tr("restart_single", counter.getColorText(), this.tr("counter_name", new Object[0])), true);
            return 1;
        });
    }
}

