/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.tester;

import carpettisaddition.commands.speedtest.ProgressTimer;
import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.commands.speedtest.tester.SpeedTester;
import carpettisaddition.translations.TranslationContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class SpeedTesterBase
extends TranslationContext
implements SpeedTester {
    protected final int totalSizeMb;
    protected final long totalSize;
    protected final AtomicLong processedSize = new AtomicLong(0L);
    protected final AtomicInteger processedCount = new AtomicInteger(0);
    protected final ProgressTimer timer = new ProgressTimer();
    protected volatile boolean abort = false;
    private final AtomicBoolean doneExecuted = new AtomicBoolean(false);

    public SpeedTesterBase(int totalSizeMb) {
        super(SpeedTestCommand.getInstance().getTranslator());
        this.totalSizeMb = totalSizeMb;
        this.totalSize = (long)totalSizeMb << 20;
    }

    @Override
    public void start() {
        this.timer.start();
    }

    @Override
    public void abort() {
        this.abort = true;
        this.onDoneWrapper();
    }

    protected void onPayloadDone() {
        int processedCount = this.processedCount.addAndGet(1);
        long processedSize = this.processedSize.addAndGet(16384L);
        this.onProgress(processedSize, this.totalSize);
        if (processedSize >= this.totalSize || this.abort) {
            this.onDoneWrapper();
        } else {
            this.onContinue(processedCount);
        }
    }

    protected void onProgress(long sentBytes, long totalBytes) {
    }

    protected void onDone(long timeCostNs) {
    }

    protected void onContinue(int processedCount) {
    }

    private void onDoneWrapper() {
        if (this.doneExecuted.compareAndSet(false, true)) {
            this.onDone(this.timer.getTimeElapsedNs());
        }
    }
}

