/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.syncServerMsptMetricsData;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.network.TISCMClientPacketHandler;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import carpettisaddition.utils.NbtUtils;
import carpettisaddition.utils.compat.ServerTickType;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_8743;

public class ServerMsptMetricsDataSyncer {
    private static final ServerMsptMetricsDataSyncer INSTANCE = new ServerMsptMetricsDataSyncer();
    private static final ServerTickType SERVER_TICK_TYPE_FALLBACK = ServerTickType.TICK_SERVER_METHOD;
    private static final long M = 1000000L;
    private class_8743 metricsData;
    private final Set<ServerTickType> sentTypesThisTick = Sets.newHashSet();
    private long tickCounterThisTick = -1L;

    private ServerMsptMetricsDataSyncer() {
        this.reset();
    }

    public static ServerMsptMetricsDataSyncer getInstance() {
        return INSTANCE;
    }

    public void broadcastSample(long tickCounter, long nanosecond, ServerTickType serverTickType) {
        if (tickCounter != this.tickCounterThisTick) {
            this.sentTypesThisTick.clear();
            this.tickCounterThisTick = tickCounter;
        }
        if (!this.sentTypesThisTick.add(serverTickType)) {
            return;
        }
        TISCMServerPacketHandler.getInstance().broadcast(TISCMProtocol.S2C.MSPT_METRICS_SAMPLE, nbt -> {
            nbt.method_10569("version", 2);
            nbt.method_10544("millisecond", nanosecond / 1000000L);
            nbt.method_10544("nanosecond", nanosecond);
            nbt.method_10582("type", serverTickType.toString().toLowerCase());
        });
    }

    public void broadcastSampleLegacy(long tickCounter, long millisecond) {
        this.broadcastSample(tickCounter, millisecond * 1000000L, SERVER_TICK_TYPE_FALLBACK);
    }

    public void receiveMetricData(class_2487 nbt) {
        long nanosecond = NbtUtils.getLongOrZero(nbt, "millisecond") * 1000000L;
        if (nbt.method_10545("nanosecond")) {
            nanosecond = NbtUtils.getLongOrZero(nbt, "nanosecond");
        }
        try {
            ServerTickType type = ServerTickType.valueOf(NbtUtils.getStringOrEmpty(nbt, "type").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ServerTickType type = SERVER_TICK_TYPE_FALLBACK;
        }
        this.metricsData.method_53066(nanosecond / 1000000L);
    }

    public class_8743 getMetricsData() {
        return this.metricsData;
    }

    public void reset() {
        this.metricsData = new class_8743();
    }

    public boolean isServerSupportOk() {
        return CarpetTISAdditionSettings.syncServerMsptMetricsData && TISCMClientPacketHandler.getInstance().isProtocolEnabled();
    }

    public void clientTick() {
    }
}

