/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.deobfuscator.yarn;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.utils.FileUtils;
import carpettisaddition.utils.MiscUtils;
import carpettisaddition.utils.deobfuscator.StackTraceDeobfuscator;
import carpettisaddition.utils.deobfuscator.yarn.YarnVersionCache;
import com.google.common.collect.Lists;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_156;
import org.apache.logging.log4j.Logger;

public class OnlineMappingProvider {
    private static final Logger LOGGER = CarpetTISAdditionServer.LOGGER;
    public static final String MINECRAFT_VERSION = (String)class_156.method_656(() -> {
        class_155.method_36208();
        return class_155.method_16673().method_48018();
    });
    public static final String YARN_META_URL = "https://meta.fabricmc.net/v2/versions/yarn/" + MINECRAFT_VERSION;
    public static final String YARN_MAPPING_URL_BASE = "https://maven.fabricmc.net/net/fabricmc/yarn/";
    public static final String MAPPINGS_JAR_LOCATION = "mappings/mappings.tiny";
    public static final String STORAGE_DIRECTORY = String.format("./config/%s/mapping/", CarpetTISAdditionServer.compactName);
    public static final String YARN_VERSION_CACHE_FILE = STORAGE_DIRECTORY + "yarn_version.json";

    private static String getMappingFileName(String yarnVersion) {
        return String.format("yarn-%s-v2", yarnVersion);
    }

    private static String getMappingFileNameFull(String yarnVersion) {
        return OnlineMappingProvider.getMappingFileName(yarnVersion) + ".tiny";
    }

    private static String getYarnVersionOnline() throws IOException {
        URL url = URI.create(YARN_META_URL).toURL();
        URLConnection request = url.openConnection();
        ArrayList list = Lists.newArrayList();
        JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(request.getInputStream()));
        json.getAsJsonArray().forEach(e -> {
            JsonObject object = e.getAsJsonObject();
            list.add(Pair.of((Object)object.get("build").getAsInt(), (Object)object.get("version").getAsString()));
        });
        return (String)list.stream().max(Comparator.comparingInt(Pair::getFirst)).orElseThrow(() -> new IOException("Empty list")).getSecond();
    }

    private static synchronized String getYarnVersion(boolean useCache) throws IOException {
        ArrayList cacheList = Lists.newArrayList();
        File file = new File(YARN_VERSION_CACHE_FILE);
        if (FileUtils.isFile(file)) {
            YarnVersionCache[] caches = null;
            try {
                caches = (YarnVersionCache[])new Gson().fromJson((Reader)new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0])), YarnVersionCache[].class);
            }
            catch (Exception e) {
                CarpetTISAdditionMod.LOGGER.warn("Failed to deserialize data from {}: {}", (Object)YARN_VERSION_CACHE_FILE, (Object)e);
            }
            if (caches != null) {
                cacheList.addAll(Arrays.asList(caches));
            }
        }
        YarnVersionCache storedCache = null;
        for (YarnVersionCache cache : cacheList) {
            if (!cache.minecraftVersion.equals(MINECRAFT_VERSION)) continue;
            storedCache = cache;
            break;
        }
        if (useCache && storedCache != null) {
            LOGGER.debug("Found yarn version from file cache");
            return storedCache.yarnVersion;
        }
        String yarnVersion = OnlineMappingProvider.getYarnVersionOnline();
        cacheList.remove(storedCache);
        cacheList.add(new YarnVersionCache(MINECRAFT_VERSION, yarnVersion));
        FileUtils.touchFileDirectory(file);
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)cacheList));
        writer.flush();
        writer.close();
        return yarnVersion;
    }

    private static synchronized FileInputStream getYarnMappingStream(String yarnVersion) throws IOException {
        File mappingFile = new File(STORAGE_DIRECTORY + OnlineMappingProvider.getMappingFileNameFull(yarnVersion));
        if (!FileUtils.isFile(mappingFile)) {
            String mappingJar = String.format("%s.jar", OnlineMappingProvider.getMappingFileName(yarnVersion));
            String mappingJarUrl = String.format("%s%s/%s", YARN_MAPPING_URL_BASE, yarnVersion, mappingJar);
            String escapedUrl = UrlEscapers.urlFragmentEscaper().escape(mappingJarUrl);
            LOGGER.info("Downloading yarn mapping from {}", (Object)escapedUrl);
            File jarFile = new File(STORAGE_DIRECTORY + mappingJar);
            org.apache.commons.io.FileUtils.copyURLToFile((URL)URI.create(escapedUrl).toURL(), (File)jarFile);
            try (FileSystem jar = FileSystems.newFileSystem(jarFile.toPath(), (ClassLoader)null);){
                Files.copy(jar.getPath(MAPPINGS_JAR_LOCATION, new String[0]), mappingFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.delete(jarFile.toPath());
        }
        return new FileInputStream(mappingFile);
    }

    private static synchronized void loadMappings(InputStream mappingStream, String yarnVersion) {
        if (StackTraceDeobfuscator.loadMappings(mappingStream, "Yarn " + yarnVersion)) {
            LOGGER.info("Yarn mapping file {} loaded", (Object)OnlineMappingProvider.getMappingFileNameFull(yarnVersion));
        }
    }

    private static void getMappingThreaded() {
        try {
            OnlineMappingProvider.moveFilesIntoMappingDir();
            String yarnVersion = OnlineMappingProvider.getYarnVersion(true);
            LOGGER.debug("Got yarn version for Minecraft {}: {}", (Object)MINECRAFT_VERSION, (Object)yarnVersion);
            FileInputStream mappingStream = OnlineMappingProvider.getYarnMappingStream(yarnVersion);
            OnlineMappingProvider.loadMappings(mappingStream, yarnVersion);
        }
        catch (IOException e) {
            LOGGER.error("Failed to get yarn mapping, the stack trace deobfuscator will not work: {}", (Object)e.toString());
        }
    }

    private static void checkYarnVersionUpdate(String currentYarnVersion) {
        try {
            String newVersion = OnlineMappingProvider.getYarnVersion(false);
            if (!currentYarnVersion.equals(newVersion)) {
                LOGGER.info("New yarn version detected: {} -> {}", (Object)currentYarnVersion, (Object)newVersion);
                FileInputStream mappingStream = OnlineMappingProvider.getYarnMappingStream(newVersion);
                OnlineMappingProvider.loadMappings(mappingStream, newVersion);
                File oldMapping = new File(STORAGE_DIRECTORY + OnlineMappingProvider.getMappingFileNameFull(currentYarnVersion));
                Files.delete(oldMapping.toPath());
            }
        }
        catch (IOException e) {
            LOGGER.error("Check yarn version update failed: {}", (Object)e.toString());
        }
    }

    private static void moveFilesIntoMappingDir() throws IOException {
        String MAPPING_STORAGE_DIRECTORY_OLD = String.format("./config/%s/", CarpetTISAdditionServer.compactName);
        String MAPPING_CONFIG = "yarn_version.json";
        String MAPPING_SUFFIX = "-v2.tiny";
        List targets = null;
        try (Stream<Path> paths = Files.list(new File(MAPPING_STORAGE_DIRECTORY_OLD).toPath());){
            targets = paths.map(Path::toFile).filter(File::isFile).filter(file -> file.getName().equals("yarn_version.json") || file.getName().endsWith("-v2.tiny")).collect(Collectors.toList());
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        if (targets != null && !targets.isEmpty()) {
            FileUtils.touchDirectory(new File(STORAGE_DIRECTORY));
            for (File file2 : targets) {
                Files.move(file2.toPath(), new File(STORAGE_DIRECTORY).toPath().resolve(file2.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static void getMapping() {
        MiscUtils.startThread("TISCM Mapping", OnlineMappingProvider::getMappingThreaded);
    }
}

